"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStartMlJobs = void 0;
var _react = require("react");
var _helpers = require("../../../../common/machine_learning/helpers");
var _use_security_jobs = require("../../../common/components/ml_popover/hooks/use_security_jobs");
var _use_enable_data_feed = require("../../../common/components/ml_popover/hooks/use_enable_data_feed");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStartMlJobs = () => {
  const {
    enableDatafeed,
    isLoading: isLoadingEnableDataFeed
  } = (0, _use_enable_data_feed.useEnableDataFeed)();
  const {
    loading: isLoadingJobs,
    jobs: mlJobs,
    refetch: refetchJobs
  } = (0, _use_security_jobs.useSecurityJobs)();
  const [isStartingJobs, setIsStartingJobs] = (0, _react.useState)(false);
  const startMlJobs = (0, _react.useCallback)(async jobIds => {
    if (isLoadingJobs || isLoadingEnableDataFeed) {
      return;
    }
    if (!jobIds || !jobIds.length) {
      return;
    }

    // The error handling happens inside `enableDatafeed`, so no need to do try/catch here
    setIsStartingJobs(true);
    const ruleJobs = mlJobs.filter(job => jobIds.includes(job.id));
    await Promise.all(ruleJobs.map(async job => {
      var _job$latestTimestampM;
      if ((0, _helpers.isJobStarted)(job.jobState, job.datafeedState)) {
        return true;
      }
      const latestTimestampMs = (_job$latestTimestampM = job.latestTimestampMs) !== null && _job$latestTimestampM !== void 0 ? _job$latestTimestampM : 0;
      await enableDatafeed(job, latestTimestampMs);
    }));
    refetchJobs();
    setIsStartingJobs(false);
  }, [enableDatafeed, isLoadingEnableDataFeed, isLoadingJobs, mlJobs, refetchJobs]);
  return {
    loading: isLoadingJobs,
    jobs: mlJobs,
    starting: isStartingJobs,
    startMlJobs
  };
};
exports.useStartMlJobs = useStartMlJobs;