"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatMatchRuleFieldEdit = ThreatMatchRuleFieldEdit;
var _react = _interopRequireDefault(require("react"));
var _utility_types = require("../../../../../../../common/utility_types");
var _kql_query = require("./fields/kql_query");
var _data_source = require("./fields/data_source");
var _alert_suppression = require("./fields/alert_suppression");
var _threat_match_index = require("./fields/threat_match_index");
var _threat_match_query = require("./fields/threat_match_query");
var _threat_match_mapping = require("./fields/threat_match_mapping");
var _threat_index_indicator_path = require("./fields/threat_index_indicator_path");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ThreatMatchRuleFieldEdit({
  fieldName
}) {
  switch (fieldName) {
    case 'kql_query':
      return /*#__PURE__*/_react.default.createElement(_kql_query.KqlQueryEditForm, null);
    case 'data_source':
      return /*#__PURE__*/_react.default.createElement(_data_source.DataSourceEditForm, null);
    case 'alert_suppression':
      return /*#__PURE__*/_react.default.createElement(_alert_suppression.AlertSuppressionEditForm, null);
    case 'threat_index':
      return /*#__PURE__*/_react.default.createElement(_threat_match_index.ThreatMatchIndexEditForm, null);
    case 'threat_query':
      return /*#__PURE__*/_react.default.createElement(_threat_match_query.ThreatMatchQueryEditForm, null);
    case 'threat_mapping':
      return /*#__PURE__*/_react.default.createElement(_threat_match_mapping.ThreatMatchMappingEditForm, null);
    case 'threat_indicator_path':
      return /*#__PURE__*/_react.default.createElement(_threat_index_indicator_path.ThreatMatchIndicatorPathEditForm, null);
    default:
      return (0, _utility_types.assertUnreachable)(fieldName);
  }
}