"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThresholdAlertSuppressionEditForm = ThresholdAlertSuppressionEditForm;
var _react = _interopRequireDefault(require("react"));
var _threshold_alert_suppression_edit = require("../../../../../../../rule_creation/components/threshold_alert_suppression_edit");
var _alert_suppression_edit = require("../../../../../../../rule_creation/components/alert_suppression_edit");
var _field_final_side = require("../../../field_final_side");
var _form_schema = require("./form_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ThresholdAlertSuppressionEditForm() {
  return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
    component: ThresholdAlertSuppressionEditAdapter,
    ruleFieldFormSchema: _form_schema.thresholdAlertSuppressionFormSchema,
    deserializer: deserializer,
    serializer: serializer
  });
}
function ThresholdAlertSuppressionEditAdapter({
  finalDiffableRule
}) {
  if (finalDiffableRule.type !== 'threshold') {
    throw new Error('Threshold rule type expected');
  }
  const suppressibleFields = [finalDiffableRule.threshold.field].flat();
  return /*#__PURE__*/_react.default.createElement(_threshold_alert_suppression_edit.ThresholdAlertSuppressionEdit, {
    suppressionFieldNames: suppressibleFields
  });
}
function deserializer(defaultValue) {
  var _alertSuppression$dur;
  const alertSuppression = defaultValue.alert_suppression;
  return {
    [_threshold_alert_suppression_edit.THRESHOLD_ALERT_SUPPRESSION_ENABLED]: Boolean(alertSuppression === null || alertSuppression === void 0 ? void 0 : alertSuppression.duration),
    [_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_FIELD_NAME]: (_alertSuppression$dur = alertSuppression === null || alertSuppression === void 0 ? void 0 : alertSuppression.duration) !== null && _alertSuppression$dur !== void 0 ? _alertSuppression$dur : {
      value: 5,
      unit: 'm'
    }
  };
}
function serializer(formData) {
  const alertSuppressionFormData = formData;
  if (!alertSuppressionFormData[_threshold_alert_suppression_edit.THRESHOLD_ALERT_SUPPRESSION_ENABLED]) {
    return {};
  }
  return {
    alert_suppression: {
      duration: alertSuppressionFormData[_alert_suppression_edit.ALERT_SUPPRESSION_DURATION_FIELD_NAME]
    }
  };
}