"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedIntegrationsEdit = RelatedIntegrationsEdit;
exports.relatedIntegrationsDeserializer = relatedIntegrationsDeserializer;
exports.relatedIntegrationsSchema = void 0;
exports.relatedIntegrationsSerializer = relatedIntegrationsSerializer;
var _react = _interopRequireDefault(require("react"));
var _schema = require("../../../../../../rule_creation_ui/components/step_define_rule/schema");
var _related_integrations = require("../../../../../../rule_creation/components/related_integrations");
var _helpers = require("../../../../../../rule_creation_ui/pages/rule_creation/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const relatedIntegrationsSchema = exports.relatedIntegrationsSchema = {
  relatedIntegrations: _schema.schema.relatedIntegrations
};
function RelatedIntegrationsEdit() {
  return /*#__PURE__*/_react.default.createElement(_related_integrations.RelatedIntegrations, {
    path: "relatedIntegrations"
  });
}
function relatedIntegrationsDeserializer(defaultValue) {
  return {
    relatedIntegrations: defaultValue.related_integrations
  };
}
function relatedIntegrationsSerializer(formData) {
  var _formData$relatedInte;
  const relatedIntegrations = (_formData$relatedInte = formData.relatedIntegrations) !== null && _formData$relatedInte !== void 0 ? _formData$relatedInte : [];
  return {
    related_integrations: (0, _helpers.filterOutEmptyRelatedIntegrations)(relatedIntegrations)
  };
}