"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourceInfoText = DataSourceInfoText;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _doc_link = require("../../../../../../../../common/components/links_to_docs/doc_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DataSourceInfoText() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.dataViewSelectorText1",
    defaultMessage: "Use Kibana "
  }), /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
    guidePath: "kibana",
    docPath: "data-views.html",
    linkText: "Data Views"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.dataViewSelectorText2",
    defaultMessage: " or specify individual "
  }), /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
    guidePath: "kibana",
    docPath: "index-patterns-api-create.html",
    linkText: "index patterns"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.dataViewSelectorText3",
    defaultMessage: " as your rule's data source to be searched."
  }));
}