"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSubfieldChangesForKqlQuery = void 0;
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSubfieldChangesForKqlQuery = (oldFieldValue, newFieldValue) => {
  const changes = [];
  const oldType = (0, _utils.stringifyToSortedJson)(oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.type);
  const newType = (0, _utils.stringifyToSortedJson)(newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.type);
  if (oldType !== newType) {
    changes.push({
      subfieldName: 'type',
      oldSubfieldValue: oldType,
      newSubfieldValue: newType
    });
  }
  const oldQuery = (0, _utils.stringifyToSortedJson)((oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.type) === 'inline_query' ? oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.query : '');
  const newQuery = (0, _utils.stringifyToSortedJson)((newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.type) === 'inline_query' ? newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.query : '');
  if (oldQuery !== newQuery) {
    changes.push({
      subfieldName: 'query',
      oldSubfieldValue: oldQuery,
      newSubfieldValue: newQuery
    });
  }
  const oldLanguage = (0, _utils.stringifyToSortedJson)((oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.type) === 'inline_query' ? oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.language : '');
  const newLanguage = (0, _utils.stringifyToSortedJson)((newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.type) === 'inline_query' ? newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.language : '');
  if (oldLanguage !== newLanguage) {
    changes.push({
      subfieldName: 'language',
      oldSubfieldValue: oldLanguage,
      newSubfieldValue: newLanguage
    });
  }
  const oldFilters = (0, _utils.stringifyToSortedJson)((oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.type) === 'inline_query' ? oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.filters : '');
  const newFilters = (0, _utils.stringifyToSortedJson)((newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.type) === 'inline_query' ? newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.filters : '');
  if (oldFilters !== newFilters) {
    changes.push({
      subfieldName: 'filters',
      oldSubfieldValue: oldFilters,
      newSubfieldValue: newFilters
    });
  }
  const oldSavedQueryId = (0, _utils.stringifyToSortedJson)((oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.type) === 'saved_query' ? oldFieldValue === null || oldFieldValue === void 0 ? void 0 : oldFieldValue.saved_query_id : '');
  const newSavedQueryId = (0, _utils.stringifyToSortedJson)((newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.type) === 'saved_query' ? newFieldValue === null || newFieldValue === void 0 ? void 0 : newFieldValue.saved_query_id : '');
  if (oldSavedQueryId !== newSavedQueryId) {
    changes.push({
      subfieldName: 'saved_query_id',
      oldSubfieldValue: oldSavedQueryId,
      newSubfieldValue: newSavedQueryId
    });
  }
  return changes;
};
exports.getSubfieldChangesForKqlQuery = getSubfieldChangesForKqlQuery;