"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOverviewTabSections = exports.RuleOverviewTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _rule_about_section = require("./rule_about_section");
var _rule_definition_section = require("./rule_definition_section");
var _rule_schedule_section = require("./rule_schedule_section");
var _rule_setup_guide_section = require("./rule_setup_guide_section");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultOverviewOpenSections = {
  about: true,
  definition: true,
  schedule: true,
  setup: true
};
const useOverviewTabSections = () => {
  const [expandedOverviewSections, setOpenOverviewSections] = (0, _react.useState)(defaultOverviewOpenSections);
  const toggleSection = (0, _react.useCallback)(sectionName => {
    setOpenOverviewSections(prevOpenSections => ({
      ...prevOpenSections,
      [sectionName]: !prevOpenSections[sectionName]
    }));
  }, []);
  const toggleOverviewSection = (0, _react.useMemo)(() => ({
    about: () => toggleSection('about'),
    definition: () => toggleSection('definition'),
    schedule: () => toggleSection('schedule'),
    setup: () => toggleSection('setup')
  }), [toggleSection]);
  return {
    expandedOverviewSections,
    toggleOverviewSection
  };
};
exports.useOverviewTabSections = useOverviewTabSections;
const ExpandableSection = ({
  title,
  isOpen,
  toggle,
  children
}) => {
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'accordion'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    forceState: isOpen ? 'open' : 'closed',
    onToggle: toggle,
    paddingSize: "none",
    id: accordionId,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, title)),
    initialIsOpen: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column"
  }, children));
};
const RuleOverviewTab = ({
  rule,
  columnWidths = _constants.DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS,
  expandedOverviewSections,
  toggleOverviewSection
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(ExpandableSection, {
    title: i18n.ABOUT_SECTION_LABEL,
    isOpen: expandedOverviewSections.about,
    toggle: toggleOverviewSection.about
  }, rule.description && /*#__PURE__*/_react.default.createElement(_rule_about_section.Description, {
    description: rule.description
  }), /*#__PURE__*/_react.default.createElement(_rule_about_section.RuleAboutSection, {
    rule: rule,
    columnWidths: columnWidths,
    hideDescription: true,
    hideName: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(ExpandableSection, {
    title: i18n.DEFINITION_SECTION_LABEL,
    isOpen: expandedOverviewSections.definition,
    toggle: toggleOverviewSection.definition
  }, /*#__PURE__*/_react.default.createElement(_rule_definition_section.RuleDefinitionSection, {
    rule: rule,
    columnWidths: columnWidths
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(ExpandableSection, {
    title: i18n.SCHEDULE_SECTION_LABEL,
    isOpen: expandedOverviewSections.schedule,
    toggle: toggleOverviewSection.schedule
  }, /*#__PURE__*/_react.default.createElement(_rule_schedule_section.RuleScheduleSection, {
    rule: rule,
    columnWidths: columnWidths
  })), rule.setup && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(ExpandableSection, {
    title: i18n.SETUP_GUIDE_SECTION_LABEL,
    isOpen: expandedOverviewSections.setup,
    toggle: toggleOverviewSection.setup
  }, /*#__PURE__*/_react.default.createElement(_rule_setup_guide_section.RuleSetupGuideSection, {
    setup: rule.setup
  }))));
};
exports.RuleOverviewTab = RuleOverviewTab;