"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldGroupDiffComponent = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _split_accordion = require("../../../../../common/components/split_accordion");
var _diff_view = require("../json_diff/diff_view");
var _rule_field_diff = require("../../../model/rule_details/rule_field_diff");
var _translations = require("./translations");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SubFieldComponent = ({
  currentVersion,
  targetVersion,
  fieldName,
  shouldShowSeparator,
  shouldShowSubtitles,
  diffLayout
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceBetween"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column"
}, shouldShowSubtitles ? /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  "data-test-subj": "ruleUpgradePerFieldDiffSubtitle",
  size: "xxxs"
}, /*#__PURE__*/_react.default.createElement("h4", null, (0, _helpers.convertFieldToDisplayName)(fieldName))) : null, diffLayout === _rule_field_diff.DiffLayout.RightToLeft ? /*#__PURE__*/_react.default.createElement(_diff_view.DiffView, {
  oldSource: targetVersion,
  newSource: currentVersion
}) : /*#__PURE__*/_react.default.createElement(_diff_view.DiffView, {
  oldSource: currentVersion,
  newSource: targetVersion
}), shouldShowSeparator ? /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
  margin: "s",
  size: "full"
}) : null));
const FieldGroupDiffComponent = ({
  ruleDiffs,
  fieldsGroupName,
  diffLayout = _rule_field_diff.DiffLayout.LeftToRight
}) => {
  var _fieldToDisplayNameMa;
  const {
    fieldDiffs,
    shouldShowSubtitles
  } = ruleDiffs;
  return /*#__PURE__*/_react.default.createElement(_split_accordion.SplitAccordion, {
    header: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      "data-test-subj": "ruleUpgradePerFieldDiffLabel",
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, (_fieldToDisplayNameMa = _translations.fieldToDisplayNameMap[fieldsGroupName]) !== null && _fieldToDisplayNameMa !== void 0 ? _fieldToDisplayNameMa : (0, _lodash.startCase)((0, _lodash.camelCase)(fieldsGroupName)))),
    initialIsOpen: true,
    "data-test-subj": "ruleUpgradePerFieldDiff"
  }, fieldDiffs.map(({
    currentVersion,
    targetVersion,
    fieldName: specificFieldName
  }, index) => {
    const isLast = index === fieldDiffs.length - 1;
    return /*#__PURE__*/_react.default.createElement(SubFieldComponent, {
      key: specificFieldName,
      shouldShowSeparator: !isLast,
      shouldShowSubtitles: shouldShowSubtitles,
      currentVersion: currentVersion,
      targetVersion: targetVersion,
      fieldName: specificFieldName,
      diffLayout: diffLayout
    });
  }));
};
exports.FieldGroupDiffComponent = FieldGroupDiffComponent;