"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionItemCardHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExceptionItemCardHeader = exports.ExceptionItemCardHeader = /*#__PURE__*/(0, _react.memo)(({
  item,
  actions,
  disableActions = false,
  dataTestSubj
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onItemActionsClick = () => setIsPopoverOpen(isOpen => !isOpen);
  const onClosePopover = () => setIsPopoverOpen(false);
  const itemActions = (0, _react.useMemo)(() => {
    return actions.map(action => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": `${dataTestSubj}-actionItem-${action.key}`,
      key: action.key,
      icon: action.icon,
      onClick: () => {
        onClosePopover();
        action.onClick();
      }
    }, action.label));
  }, [dataTestSubj, actions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": dataTestSubj,
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 9
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    textTransform: "uppercase",
    "data-test-subj": `${dataTestSubj}-title`
  }, /*#__PURE__*/_react.default.createElement("h3", null, item.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      isDisabled: disableActions,
      "aria-label": "Exception item actions menu",
      iconType: "boxesHorizontal",
      onClick: onItemActionsClick,
      "data-test-subj": `${dataTestSubj}-actionButton`
    }),
    panelPaddingSize: "none",
    isOpen: isPopoverOpen,
    closePopover: onClosePopover,
    "data-test-subj": `${dataTestSubj}-items`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: itemActions
  }))));
});
ExceptionItemCardHeader.displayName = 'ExceptionItemCardHeader';