"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEsqlQueryForAboutStep = void 0;
var _react = require("react");
var _types = require("../../common/types");
var _utils = require("../../../../common/detection_engine/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 *  If about step not active, return query as undefined to prevent unnecessary re-renders
 *  ES|QL query can change frequently when user types it, so we don't want it to trigger about form step re-render, when  *  this from step not active
 *  When it is active, query would not change, as it can be edit only in define form step
 */
const useEsqlQueryForAboutStep = ({
  defineStepData,
  activeStep
}) => {
  const esqlQueryForAboutStep = (0, _react.useMemo)(() => {
    if (activeStep !== _types.RuleStep.aboutRule) {
      return undefined;
    }
    return typeof defineStepData.queryBar.query.query === 'string' && (0, _utils.isEsqlRule)(defineStepData.ruleType) ? defineStepData.queryBar.query.query : undefined;
  }, [defineStepData.queryBar.query.query, defineStepData.ruleType, activeStep]);
  return esqlQueryForAboutStep;
};
exports.useEsqlQueryForAboutStep = useEsqlQueryForAboutStep;