"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoggedRequestsQueryComponent = exports.LoggedRequestsQuery = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LoggedRequestsQueryComponent = ({
  description,
  duration,
  request
}) => {
  const paddingLarge = (0, _eui.useEuiPaddingSize)('l');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      'padding-left': paddingLarge
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "preview-logged-request-description"
  }, description !== null && description !== void 0 ? description : null, " ", duration ? `[${duration}ms]` : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), request ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    overflowHeight: 300,
    isVirtualized: true,
    "data-test-subj": "preview-logged-request-code-block"
  }, request) : null);
};
exports.LoggedRequestsQueryComponent = LoggedRequestsQueryComponent;
const LoggedRequestsQuery = exports.LoggedRequestsQuery = /*#__PURE__*/_react.default.memo(LoggedRequestsQueryComponent);
LoggedRequestsQuery.displayName = 'LoggedRequestsQuery';