"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewSelectorField = DataViewSelectorField;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _data_view_id_validator_factory = require("../../validators/data_view_id_validator_factory");
var _use_data_view_list_items = require("./use_data_view_list_items");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SECURITY_DEFAULT_DATA_VIEW_ID = 'security-solution-default';
function DataViewSelectorField({
  field
}) {
  const {
    data: dataViews,
    isFetching: areDataViewsFetching
  } = (0, _use_data_view_list_items.useDataViewListItems)();
  const fieldAndError = field ? (0, _shared_imports.getFieldValidityAndErrorMessage)(field) : undefined;
  const isInvalid = fieldAndError === null || fieldAndError === void 0 ? void 0 : fieldAndError.isInvalid;
  const errorMessage = fieldAndError === null || fieldAndError === void 0 ? void 0 : fieldAndError.errorMessage;
  const comboBoxOptions = (0, _react.useMemo)(() => dataViews.map(({
    id,
    title,
    name
  }) => ({
    id,
    label: name !== null && name !== void 0 ? name : title,
    toolTipContent: title
  })), [dataViews]);
  const selectedOption = (0, _react.useMemo)(() => comboBoxOptions.find(({
    id
  }) => id === field.value), [comboBoxOptions, field]);
  const handleDataViewsChange = (0, _react.useCallback)(options => {
    var _options$;
    return field.setValue((_options$ = options[0]) === null || _options$ === void 0 ? void 0 : _options$.id);
  }, [field]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !areDataViewsFetching && (0, _data_view_id_validator_factory.isDataViewIdValid)(field.value) && !selectedOption && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.DATA_VIEW_NOT_FOUND_WARNING_LABEL,
    color: "warning",
    iconType: "question",
    "data-test-subj": "missingDataViewWarning"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.DATA_VIEW_NOT_FOUND_WARNING_DESCRIPTION(field.value))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), field.value === SECURITY_DEFAULT_DATA_VIEW_ID && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.DATA_VIEW_ALERTS_ON_ALERTS_WARNING_LABEL,
    color: "warning",
    iconType: "question",
    "data-test-subj": "defaultSecurityDataViewWarning"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.DATA_VIEW_ALERTS_ON_ALERTS_WARNING_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: field.label,
    helpText: field.helpText,
    error: errorMessage,
    isInvalid: isInvalid,
    "data-test-subj": "pick-rule-data-source"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isInvalid: isInvalid,
    isDisabled: areDataViewsFetching,
    isClearable: true,
    singleSelection: {
      asPlainText: true
    },
    onChange: handleDataViewsChange,
    options: comboBoxOptions,
    selectedOptions: selectedOption ? [selectedOption] : [],
    "aria-label": i18n.PICK_INDEX_PATTERNS,
    placeholder: i18n.PICK_INDEX_PATTERNS,
    "data-test-subj": "detectionsDataViewSelectorDropdown"
  })));
}