"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatMatchIndexSelectorField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _constants = require("../../../../../common/constants");
var _kibana = require("../../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ThreatMatchIndexSelectorField = exports.ThreatMatchIndexSelectorField = /*#__PURE__*/(0, _react.memo)(function ThreatIndexField({
  field
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [defaultThreatIndices] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_THREAT_INDEX_KEY);
  const isIndexModified = !(0, _lodash.isEqual)(field.value, defaultThreatIndices);
  const handleResetIndices = (0, _react.useCallback)(() => field.setValue(defaultThreatIndices), [field, defaultThreatIndices]);
  return /*#__PURE__*/_react.default.createElement(_components.ComboBoxField, {
    field: field,
    idAria: "ruleThreatMatchIndicesField",
    "data-test-subj": "ruleThreatMatchIndicesField",
    euiFieldProps: EUI_COMBOBOX_PROPS,
    label: i18n.THREAT_MATCH_INDEX_FIELD_LABEL,
    labelAppend: isIndexModified ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      className: (0, _css.css)`
              height: ${euiTheme.size.base};
            `,
      size: "xs",
      iconType: "refresh",
      onClick: handleResetIndices
    }, i18n.RESET_TO_DEFAULT_THREAT_MATCH_INDEX) : undefined,
    helpText: helpText
  });
});
const EUI_COMBOBOX_PROPS = {
  fullWidth: true,
  placeholder: ''
};
const helpText = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs"
}, i18n.THREAT_MATCH_INDEX_FIELD_HELP_TEXT);