"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSavedDataViews = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _selectors = require("../redux/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a list of saved data views
 * The list excludes managed data views (default security solution data view and alert data view)
 */
const useSavedDataViews = () => {
  const {
    dataViews: dataViewSpecs,
    defaultDataViewId,
    alertDataViewId
  } = (0, _reactRedux.useSelector)(_selectors.sharedStateSelector);
  return (0, _react.useMemo)(() => dataViewSpecs.filter(dv => dv.id !== defaultDataViewId && dv.id !== alertDataViewId).map(spec => {
    var _spec$id, _spec$title;
    return {
      id: (_spec$id = spec.id) !== null && _spec$id !== void 0 ? _spec$id : '',
      title: (_spec$title = spec.title) !== null && _spec$title !== void 0 ? _spec$title : '',
      name: spec.name
    };
  }), [dataViewSpecs, defaultDataViewId, alertDataViewId]);
};
exports.useSavedDataViews = useSavedDataViews;