"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesTourSteps = void 0;
var _react = _interopRequireWildcard(require("react"));
var _tour_config = require("./tour_config");
var _tour_step = require("./tour_step");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSubmitButton = () => document.querySelector(`[tour-step="create-case-submit"]`);
const CasesTourSteps = () => {
  const [activeStep, setActiveStep] = (0, _react.useState)(_tour_config.AlertsCasesTourSteps.createCase);
  const scrollToSubmitButton = (0, _react.useCallback)(() => {
    var _getSubmitButton;
    (_getSubmitButton = getSubmitButton()) === null || _getSubmitButton === void 0 ? void 0 : _getSubmitButton.scrollIntoView();
  }, []);
  const onClick = (0, _react.useCallback)(() => {
    setActiveStep(_tour_config.AlertsCasesTourSteps.submitCase);
    scrollToSubmitButton();
    setTimeout(() => {
      var _getSubmitButton2;
      // something is resetting focus to close flyout button
      (_getSubmitButton2 = getSubmitButton()) === null || _getSubmitButton2 === void 0 ? void 0 : _getSubmitButton2.focus();
    }, 500);
  }, [scrollToSubmitButton]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, activeStep === _tour_config.AlertsCasesTourSteps.createCase && /*#__PURE__*/_react.default.createElement(_tour_step.GuidedOnboardingTourStep, {
    onClick: onClick,
    step: _tour_config.AlertsCasesTourSteps.createCase,
    tourId: _tour_config.SecurityStepId.alertsCases
  }), activeStep === _tour_config.AlertsCasesTourSteps.submitCase && /*#__PURE__*/_react.default.createElement(_tour_step.GuidedOnboardingTourStep, {
    step: _tour_config.AlertsCasesTourSteps.submitCase,
    tourId: _tour_config.SecurityStepId.alertsCases
  }));
};
exports.CasesTourSteps = CasesTourSteps;