"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyPrompt = (0, _styled.default)(_eui.EuiEmptyPrompt)`
  align-self: center; /* Corrects horizontal centering in IE11 */
  max-width: 60em;
`;
EmptyPrompt.displayName = 'EmptyPrompt';
const EmptyPageComponent = /*#__PURE__*/_react.default.memo(({
  actions,
  message,
  title,
  ...rest
}) => {
  const titles = Object.keys(actions);
  const maxItemWidth = 283;
  const renderActions = (0, _react.useMemo)(() => Object.values(actions).filter(a => a.label && a.url).map(({
    icon,
    label,
    target,
    url,
    descriptionTitle,
    description,
    onClick,
    fill = true
  }, idx) => descriptionTitle != null || description != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      maxWidth: maxItemWidth
    },
    key: `empty-page-${titles[idx]}-action`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    title: descriptionTitle !== null && descriptionTitle !== void 0 ? descriptionTitle : false,
    description: description !== null && description !== void 0 ? description : false,
    footer:
    /*#__PURE__*/
    /* eslint-disable-next-line @elastic/eui/href-or-on-click */
    _react.default.createElement(_eui.EuiButton, {
      href: url,
      onClick: onClick,
      iconType: icon,
      target: target,
      fill: fill,
      "data-test-subj": `empty-page-${titles[idx]}-action`
    }, label)
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      maxWidth: maxItemWidth
    },
    key: `empty-page-${titles[idx]}-action`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: url,
    onClick: onClick,
    iconType: icon,
    target: target,
    "data-test-subj": `empty-page-${titles[idx]}-action`
  }, label))), [actions, titles]);
  return /*#__PURE__*/_react.default.createElement(EmptyPrompt, (0, _extends2.default)({
    iconType: "logoSecurity",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h2", null, title)),
    body: message && /*#__PURE__*/_react.default.createElement("p", null, message),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center"
    }, renderActions)
  }, rest));
});
EmptyPageComponent.displayName = 'EmptyPageComponent';
const EmptyPage = exports.EmptyPage = /*#__PURE__*/_react.default.memo(EmptyPageComponent);
EmptyPage.displayName = 'EmptyPage';