"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmationModal = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmationModalComponent = ({
  onCancel,
  onDiscard
}) => /*#__PURE__*/_react2.default.createElement(_eui.EuiModal, {
  css: (0, _react.css)`
      max-width: 454px;
    `,
  "data-test-subj": "confirmationModal",
  onClose: onCancel
}, /*#__PURE__*/_react2.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiModalHeaderTitle, {
  "data-test-subj": "title"
}, i18n.DISCARD_UNSAVED_CHANGES)), /*#__PURE__*/_react2.default.createElement(_eui.EuiModalBody, {
  "data-test-subj": "body"
}, i18n.YOU_MADE_CHANGES, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), i18n.ARE_YOU_SURE), /*#__PURE__*/_react2.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s",
  justifyContent: "flexEnd"
}, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
  "data-test-subj": "cancel",
  onClick: onCancel
}, i18n.CANCEL)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
  color: "danger",
  "data-test-subj": "discardChanges",
  fill: true,
  onClick: onDiscard
}, i18n.DISCARD_CHANGES)))));
ConfirmationModalComponent.displayName = 'ConfirmationModal';
const ConfirmationModal = exports.ConfirmationModal = /*#__PURE__*/_react2.default.memo(ConfirmationModalComponent);