"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSelectionOld = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _alert_selection_query = require("../alert_selection_query");
var _alert_selection_range = require("../alert_selection_range");
var _get_max_alerts = require("../helpers/get_max_alerts");
var _get_tabs = require("../helpers/get_tabs");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// import type { Query } from '@kbn/es-query';

const AlertSelectionOldComponent = ({
  alertsPreviewStackBy0,
  alertSummaryStackBy0,
  filterManager,
  setAlertsPreviewStackBy0,
  setAlertSummaryStackBy0,
  onSettingsChanged,
  settings
}) => {
  const tabs = (0, _react.useMemo)(() => (0, _get_tabs.getTabs)({
    alertsPreviewStackBy0,
    alertSummaryStackBy0,
    setAlertsPreviewStackBy0,
    setAlertSummaryStackBy0,
    settings
  }), [alertsPreviewStackBy0, alertSummaryStackBy0, setAlertsPreviewStackBy0, setAlertSummaryStackBy0, settings]);
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(tabs[0].id);
  const selectedTabContent = (0, _react.useMemo)(() => {
    var _tabs$find;
    return (_tabs$find = tabs.find(obj => obj.id === selectedTabId)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content;
  }, [selectedTabId, tabs]);
  const onMaxAlertsChanged = (0, _react.useCallback)(value => {
    const maxAlerts = (0, _get_max_alerts.getMaxAlerts)(value);
    onSettingsChanged === null || onSettingsChanged === void 0 ? void 0 : onSettingsChanged({
      ...settings,
      size: maxAlerts
    });
  }, [onSettingsChanged, settings]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "alertSelection",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "customizeAlerts",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.CUSTOMIZE_THE_ALERTS))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_alert_selection_query.AlertSelectionQuery, {
    filterManager: filterManager,
    settings: settings,
    onSettingsChanged: onSettingsChanged
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_alert_selection_range.AlertSelectionRange, {
    maxAlerts: settings.size,
    setMaxAlerts: onMaxAlertsChanged
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    "data-test-subj": "tabs"
  }, tabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: tab.id,
    isSelected: tab.id === selectedTabId,
    onClick: () => setSelectedTabId(tab.id)
  }, tab.name))), selectedTabContent);
};
AlertSelectionOldComponent.displayName = 'AlertSelectionOldC';
const AlertSelectionOld = exports.AlertSelectionOld = /*#__PURE__*/_react.default.memo(AlertSelectionOldComponent);