"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisibilityFilter = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("../translations"));
var _use_find_attack_discoveries = require("../../../../use_find_attack_discoveries");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LIST_PROPS = {
  isVirtualized: false,
  rowHeight: 60
};
const ONLY_VISIBLE_TO_ME = 'only-visible-to-me';
const SHARED_KEY = 'shared';
const VisibilityFilterComponent = ({
  isLoading = false,
  setShared,
  shared
}) => {
  const invalidateFindAttackDiscoveries = (0, _use_find_attack_discoveries.useInvalidateFindAttackDiscoveries)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const onFilterButtonClick = (0, _react2.useCallback)(() => {
    setIsPopoverOpen(isOpen => !isOpen);
  }, []);
  const closePopover = (0, _react2.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const filterGroupPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'visibilityFilterGroupPopover'
  });
  const [items, setItems] = (0, _react2.useState)([{
    checked: !shared ? 'on' : undefined,
    data: {
      description: i18n.ONLY_VISIBLE_TO_YOU
    },
    'data-test-subj': 'onlyVisibleToMe',
    key: ONLY_VISIBLE_TO_ME,
    label: i18n.NOT_SHARED
  }, {
    checked: shared === undefined || shared ? 'on' : undefined,
    data: {
      description: i18n.VISIBLE_TO_YOUR_TEAM
    },
    'data-test-subj': 'shared',
    key: SHARED_KEY,
    label: i18n.SHARED
  }]);
  const renderOption = (0, _react2.useCallback)(option => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
          height: 53px;
          width: 132px;
        `,
    direction: "column",
    gutterSize: "none",
    justifyContent: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
              font-weight: bold;
            `,
    "data-test-subj": "optionLabel",
    size: "s"
  }, option.label)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    "data-test-subj": "optionDescription",
    size: "s"
  }, option.description))), []);
  const button = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiFilterButton, {
    badgeColor: "subdued",
    disabled: isLoading,
    iconType: "arrowDown",
    isSelected: isPopoverOpen,
    onClick: onFilterButtonClick,
    hasActiveFilters: !!items.find(item => item.checked === 'on'),
    numActiveFilters: items.filter(item => item.checked === 'on').length
  }, i18n.VISIBILITY), [isLoading, isPopoverOpen, items, onFilterButtonClick]);
  const onSelectableChange = (0, _react2.useCallback)(newOptions => {
    const newOnlyVisibleToMeOption = newOptions.find(option => option.key === ONLY_VISIBLE_TO_ME);
    const newSharedOption = newOptions.find(option => option.key === SHARED_KEY);
    const isOnlyVisibleToMeChecked = (newOnlyVisibleToMeOption === null || newOnlyVisibleToMeOption === void 0 ? void 0 : newOnlyVisibleToMeOption.checked) === 'on';
    const isSharedChecked = (newSharedOption === null || newSharedOption === void 0 ? void 0 : newSharedOption.checked) === 'on';
    if (isOnlyVisibleToMeChecked && isSharedChecked || !isOnlyVisibleToMeChecked && !isSharedChecked) {
      setShared(undefined);
    } else {
      setShared(isSharedChecked);
    }
    setItems(newOptions);
    invalidateFindAttackDiscoveries();
  }, [invalidateFindAttackDiscoveries, setShared]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    button: button,
    closePopover: closePopover,
    id: filterGroupPopoverId,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSelectable, {
    "aria-label": i18n.VISIBILITY,
    listProps: LIST_PROPS,
    options: items,
    onChange: onSelectableChange,
    renderOption: renderOption
  }, list => /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
                width: 230px;
              `
  }, list))));
};
VisibilityFilterComponent.displayName = 'VisibilityFilter';
const VisibilityFilter = exports.VisibilityFilter = /*#__PURE__*/_react2.default.memo(VisibilityFilterComponent);