"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createConversations = void 0;
var _datemath = require("@kbn/datemath");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _constants = require("@kbn/triggers-actions-ui-plugin/public/common/constants");
var _i18n = require("@kbn/i18n");
var _common = require("../../../common");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOCAL_CONVERSATIONS_MIGRATION_STATUS_TOAST_TITLE = _i18n.i18n.translate('xpack.securitySolution.assistant.conversationMigrationStatus.title', {
  defaultMessage: 'Local storage conversations persisted successfully.'
});
const createConversations = async (notifications, http, storage) => {
  // migrate conversations with messages from the local storage
  // won't happen next time
  const conversations = storage.get(`${_common.APP_ID}.${_helpers.LOCAL_STORAGE_KEY}`);
  if (conversations && Object.keys(conversations).length > 0) {
    const conversationsToCreate = Object.values(conversations).filter(
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    c => c.messages && c.messages.length > 0);
    const transformMessage = m => {
      var _parse, _m$timestamp;
      const timestamp = (_parse = (0, _datemath.parse)((_m$timestamp = m.timestamp) !== null && _m$timestamp !== void 0 ? _m$timestamp : '')) === null || _parse === void 0 ? void 0 : _parse.toISOString();
      return {
        ...m,
        timestamp: timestamp == null ? new Date().toISOString() : timestamp
      };
    };
    const connectors = await (0, _constants.loadAllActions)({
      http
    });

    // post bulk create
    const bulkResult = await (0, _elasticAssistant.bulkUpdateConversations)(http, {
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      create: conversationsToCreate.reduce((res, c) => {
        var _c$messages;
        // ensure actionTypeId is added to apiConfig from legacy conversation data
        if (c.apiConfig && !c.apiConfig.actionTypeId) {
          const selectedConnector = (connectors !== null && connectors !== void 0 ? connectors : []).find(connector => connector.id === c.apiConfig.connectorId);
          if (selectedConnector) {
            c.apiConfig = {
              ...c.apiConfig,
              actionTypeId: selectedConnector.actionTypeId
            };
          } else {
            c.apiConfig = undefined;
          }
        }
        res[c.id] = {
          ...c,
          messages: ((_c$messages = c.messages) !== null && _c$messages !== void 0 ? _c$messages : []).map(transformMessage),
          title: c.id,
          replacements: c.replacements
        };
        return res;
      }, {})
    }, notifications.toasts);
    if (bulkResult && bulkResult.success) {
      var _notifications$toasts;
      storage.remove(`${_common.APP_ID}.${_helpers.LOCAL_STORAGE_KEY}`);
      (_notifications$toasts = notifications.toasts) === null || _notifications$toasts === void 0 ? void 0 : _notifications$toasts.addSuccess({
        iconType: 'check',
        title: LOCAL_CONVERSATIONS_MIGRATION_STATUS_TOAST_TITLE
      });
      return true;
    }
    return false;
  }
};
exports.createConversations = createConversations;