"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assetIntegrationDocsNavigation = exports.TEST_SUBJ_PAGE_TITLE = exports.TEST_SUBJ_ONBOARDING_SUCCESS_CALLOUT = exports.TEST_SUBJ_ONBOARDING_PERMISSION_DENIED = exports.TEST_SUBJ_ONBOARDING_NO_DATA_FOUND = exports.TEST_SUBJ_ONBOARDING_INITIALIZING = exports.TEST_SUBJ_ONBOARDING_GET_STARTED = exports.TEST_SUBJ_LOADING = exports.TEST_SUBJ_GROUPING_LOADING = exports.TEST_SUBJ_GROUPING_COUNTER = exports.TEST_SUBJ_GROUPING = exports.TEST_SUBJ_EMPTY_STATE = exports.TEST_SUBJ_DATA_GRID = exports.TEST_SUBJ_AWS_CLOUD_FORMATION_ACCORDIAN_BUTTON = exports.TEST_SUBJ_AWS_CLOUD_FORMATION_ACCORDIAN = exports.QUERY_KEY_GROUPING_DATA = exports.QUERY_KEY_GRID_DATA = exports.QUERY_KEY_CHART_DATA = exports.MAX_ASSETS_TO_LOAD = exports.LOCAL_STORAGE_ONBOARDING_SUCCESS_CALLOUT_KEY = exports.LOCAL_STORAGE_DATA_TABLE_PAGE_SIZE_KEY = exports.LOCAL_STORAGE_DATA_TABLE_COLUMNS_KEY = exports.LOCAL_STORAGE_COLUMNS_SETTINGS_KEY = exports.LOCAL_STORAGE_COLUMNS_KEY = exports.LOCAL_STORAGE_ASSETS_GROUPING_KEY = exports.DOCS_URL = exports.DEFAULT_VISIBLE_ROWS_PER_PAGE = exports.DEFAULT_TABLE_SECTION_HEIGHT = exports.CLOUD_ASSET_DISCOVERY_INTEGRATION_PACKAGE_NAME = exports.ASSET_INVENTORY_TABLE_ID = exports.ASSET_INVENTORY_INDEX_PATTERN = exports.ASSET_INVENTORY_DATA_VIEW_ID_PREFIX = exports.ASSET_INVENTORY_CLOUD_CREDENTIALS_PACKAGE_VERSION = exports.ASSET_GROUPING_OPTIONS = exports.ASSET_FIELDS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_ASSETS_TO_LOAD = exports.MAX_ASSETS_TO_LOAD = 500;
const DEFAULT_VISIBLE_ROWS_PER_PAGE = exports.DEFAULT_VISIBLE_ROWS_PER_PAGE = 25;
const ASSET_INVENTORY_INDEX_PATTERN = exports.ASSET_INVENTORY_INDEX_PATTERN = 'entities-generic-latest';
const ASSET_INVENTORY_DATA_VIEW_ID_PREFIX = exports.ASSET_INVENTORY_DATA_VIEW_ID_PREFIX = 'asset-inventory';
const QUERY_KEY_GRID_DATA = exports.QUERY_KEY_GRID_DATA = 'asset_inventory_grid_data';
const QUERY_KEY_CHART_DATA = exports.QUERY_KEY_CHART_DATA = 'asset_inventory_chart_data';
const QUERY_KEY_GROUPING_DATA = exports.QUERY_KEY_GROUPING_DATA = 'asset-inventory-grouping-data';
const ASSET_INVENTORY_TABLE_ID = exports.ASSET_INVENTORY_TABLE_ID = 'asset-inventory-table';
const LOCAL_STORAGE_PREFIX = 'assetInventory';
const LOCAL_STORAGE_COLUMNS_KEY = exports.LOCAL_STORAGE_COLUMNS_KEY = `${LOCAL_STORAGE_PREFIX}:columns`;
const LOCAL_STORAGE_COLUMNS_SETTINGS_KEY = exports.LOCAL_STORAGE_COLUMNS_SETTINGS_KEY = `${LOCAL_STORAGE_COLUMNS_KEY}:settings`;
const LOCAL_STORAGE_DATA_TABLE_PAGE_SIZE_KEY = exports.LOCAL_STORAGE_DATA_TABLE_PAGE_SIZE_KEY = `${LOCAL_STORAGE_PREFIX}:dataTable:pageSize`;
const LOCAL_STORAGE_DATA_TABLE_COLUMNS_KEY = exports.LOCAL_STORAGE_DATA_TABLE_COLUMNS_KEY = `${LOCAL_STORAGE_PREFIX}:dataTable:columns`;
const LOCAL_STORAGE_ONBOARDING_SUCCESS_CALLOUT_KEY = exports.LOCAL_STORAGE_ONBOARDING_SUCCESS_CALLOUT_KEY = `${LOCAL_STORAGE_PREFIX}:onboarding:successCallout`;
const LOCAL_STORAGE_ASSETS_GROUPING_KEY = exports.LOCAL_STORAGE_ASSETS_GROUPING_KEY = `${LOCAL_STORAGE_PREFIX}:grouping`;
const TEST_SUBJ_DATA_GRID = exports.TEST_SUBJ_DATA_GRID = 'asset-inventory-test-subj-grid-wrapper';
const TEST_SUBJ_PAGE_TITLE = exports.TEST_SUBJ_PAGE_TITLE = 'asset-inventory-test-subj-page-title';
const TEST_SUBJ_EMPTY_STATE = exports.TEST_SUBJ_EMPTY_STATE = 'asset-inventory-empty-state';
const TEST_SUBJ_LOADING = exports.TEST_SUBJ_LOADING = 'asset-inventory-loading';
const TEST_SUBJ_ONBOARDING_GET_STARTED = exports.TEST_SUBJ_ONBOARDING_GET_STARTED = 'asset-inventory-onboarding-get-started';
const TEST_SUBJ_ONBOARDING_INITIALIZING = exports.TEST_SUBJ_ONBOARDING_INITIALIZING = 'asset-inventory-onboarding-initializing';
const TEST_SUBJ_ONBOARDING_NO_DATA_FOUND = exports.TEST_SUBJ_ONBOARDING_NO_DATA_FOUND = 'asset-inventory-onboarding-no-data-found';
const TEST_SUBJ_ONBOARDING_SUCCESS_CALLOUT = exports.TEST_SUBJ_ONBOARDING_SUCCESS_CALLOUT = 'asset-inventory-onboarding-success-callout';
const TEST_SUBJ_ONBOARDING_PERMISSION_DENIED = exports.TEST_SUBJ_ONBOARDING_PERMISSION_DENIED = 'asset-inventory-onboarding-permission-denied';
const TEST_SUBJ_GROUPING = exports.TEST_SUBJ_GROUPING = 'asset-inventory-grouping';
const TEST_SUBJ_GROUPING_LOADING = exports.TEST_SUBJ_GROUPING_LOADING = 'asset-inventory-grouping-loading';
const TEST_SUBJ_GROUPING_COUNTER = exports.TEST_SUBJ_GROUPING_COUNTER = 'asset-inventory-grouping-counter';
const TEST_SUBJ_AWS_CLOUD_FORMATION_ACCORDIAN = exports.TEST_SUBJ_AWS_CLOUD_FORMATION_ACCORDIAN = 'asset-inventory-launchAws-CloudFormation-Accordian-Instructions';
const TEST_SUBJ_AWS_CLOUD_FORMATION_ACCORDIAN_BUTTON = exports.TEST_SUBJ_AWS_CLOUD_FORMATION_ACCORDIAN_BUTTON = 'asset-inventory-launchAws-CloudFormation-Accordian-Instructions-Button';
const DOCS_URL = exports.DOCS_URL = 'https://ela.st/cloud-asset-discovery';
const assetIntegrationDocsNavigation = exports.assetIntegrationDocsNavigation = {
  overviewPath: `${DOCS_URL}`,
  getStartedPath: `${DOCS_URL}-get-started`,
  awsGetStartedPath: `${DOCS_URL}-get-started`,
  gcpGetStartedPath: `${DOCS_URL}-get-started-gcp.html`,
  azureGetStartedPath: `${DOCS_URL}-get-started-azure.html`
};
const DEFAULT_TABLE_SECTION_HEIGHT = exports.DEFAULT_TABLE_SECTION_HEIGHT = 512; // px

const ASSET_FIELDS = exports.ASSET_FIELDS = {
  ASSET_CRITICALITY: 'asset.criticality',
  CLOUD_ACCOUNT_ID: 'cloud.account.id',
  CLOUD_ACCOUNT_NAME: 'cloud.account.name',
  CLOUD_PROVIDER: 'cloud.provider',
  ENTITY_ID: 'entity.id',
  ENTITY_NAME: 'entity.name',
  ENTITY_RISK: 'entity.risk',
  ENTITY_SUB_TYPE: 'entity.sub_type',
  ENTITY_TYPE: 'entity.type',
  TIMESTAMP: '@timestamp'
};
const ASSET_GROUPING_OPTIONS = exports.ASSET_GROUPING_OPTIONS = {
  NONE: 'none',
  ASSET_CRITICALITY: ASSET_FIELDS.ASSET_CRITICALITY,
  ENTITY_TYPE: ASSET_FIELDS.ENTITY_TYPE,
  CLOUD_ACCOUNT: ASSET_FIELDS.CLOUD_ACCOUNT_ID
};
const ASSET_INVENTORY_CLOUD_CREDENTIALS_PACKAGE_VERSION = exports.ASSET_INVENTORY_CLOUD_CREDENTIALS_PACKAGE_VERSION = '0.9.0-preview02';
const CLOUD_ASSET_DISCOVERY_INTEGRATION_PACKAGE_NAME = exports.CLOUD_ASSET_DISCOVERY_INTEGRATION_PACKAGE_NAME = 'cloud_asset_inventory';