"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AwsAccountTypeSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _utils = require("../utils");
var _constants = require("./constants");
var _asset_boxed_radio_group = require("../asset_boxed_radio_group");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAwsAccountType = input => {
  var _input$streams$0$vars, _input$streams$0$vars2;
  return (_input$streams$0$vars = input.streams[0].vars) === null || _input$streams$0$vars === void 0 ? void 0 : (_input$streams$0$vars2 = _input$streams$0$vars['aws.account_type']) === null || _input$streams$0$vars2 === void 0 ? void 0 : _input$streams$0$vars2.value;
};
const getAwsAccountTypeOptions = () => {
  return [{
    id: _constants.AWS_ORGANIZATION_ACCOUNT,
    label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.awsAccountType.awsOrganizationLabel', {
      defaultMessage: 'AWS Organization'
    }),
    testId: 'awsOrganizationTestId'
  }, {
    id: _constants.AWS_SINGLE_ACCOUNT,
    label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.awsAccountType.singleAccountLabel', {
      defaultMessage: 'Single Account'
    }),
    testId: 'awsSingleTestId'
  }];
};
const AwsAccountTypeSelect = ({
  input,
  newPolicy,
  updatePolicy,
  disabled
}) => {
  const awsAccountTypeOptions = getAwsAccountTypeOptions();
  (0, _react.useEffect)(() => {
    if (!getAwsAccountType(input)) {
      updatePolicy((0, _utils.getAssetPolicy)(newPolicy, input.type, {
        'aws.account_type': {
          value: _constants.AWS_ORGANIZATION_ACCOUNT,
          type: 'text'
        }
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [input, updatePolicy]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.awsAccountTypeDescriptionLabel",
    defaultMessage: "Select between single account or organization, and then fill in the name and description to help identify this integration."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_asset_boxed_radio_group.RadioGroup, {
    disabled: disabled,
    idSelected: getAwsAccountType(input) || '',
    options: awsAccountTypeOptions,
    onChange: accountType => {
      updatePolicy((0, _utils.getAssetPolicy)(newPolicy, input.type, {
        'aws.account_type': {
          value: accountType,
          type: 'text'
        }
      }));
    },
    size: "m",
    name: "awsAccountType"
  }), getAwsAccountType(input) === _constants.AWS_ORGANIZATION_ACCOUNT && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.awsAccountType.awsOrganizationDescription",
    defaultMessage: "Connect Elastic to every AWS Account (current and future) in your environment by providing Elastic with read-only (configuration) access to your AWS organization."
  }))), getAwsAccountType(input) === _constants.AWS_SINGLE_ACCOUNT && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.awsAccountType.singleAccountDescription",
    defaultMessage: "Deploying to a single account is suitable for an initial POC. To ensure complete coverage, it is strongly recommended to deploy Cloud Asset Discovery at the organization-level, which automatically connects all accounts (both current and future)."
  }))));
};
exports.AwsAccountTypeSelect = AwsAccountTypeSelect;