"use strict";

var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AutomatedActionListRequestSchema = {
  query: _configSchema.schema.object({
    alertIds: _configSchema.schema.arrayOf(_configSchema.schema.string({
      minLength: 1
    }), {
      minSize: 1,
      validate: alertIds => {
        if (alertIds.map(v => v.trim()).some(v => !v.length)) {
          return 'alertIds cannot contain empty strings';
        }
      }
    })
  })
};
const AutomatedActionResponseRequestSchema = {
  query: _configSchema.schema.object({
    expiration: _configSchema.schema.string(),
    actionId: _configSchema.schema.string(),
    agent: _configSchema.schema.object({
      id: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())])
    })
  })
};