"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineTypeEnum = exports.TimelineType = exports.TimelineStatusEnum = exports.TimelineStatus = exports.TimelineSavedToReturnObject = exports.TimelineResponse = exports.TimelineErrorResponse = exports.TemplateTimelineTypeEnum = exports.TemplateTimelineType = exports.SortObject = exports.SortFieldTimelineEnum = exports.SortFieldTimeline = exports.SortDirectionEnum = exports.SortDirection = exports.Sort = exports.SerializedFilterQueryResult = exports.SavedTimelineWithSavedObjectId = exports.SavedTimeline = exports.SavedObjectResolveOutcomeEnum = exports.SavedObjectResolveOutcome = exports.SavedObjectResolveAliasPurposeEnum = exports.SavedObjectResolveAliasPurpose = exports.RowRendererIdEnum = exports.RowRendererId = exports.ResolvedTimeline = exports.QueryMatchResult = exports.PinnedEventCreatedAndUpdatedMetadata = exports.PinnedEvent = exports.PersistTimelineResponse = exports.NoteCreatedAndUpdatedMetadata = exports.Note = exports.ImportTimelines = exports.ImportTimelineResult = exports.FilterTimelineResult = exports.FavoriteTimelineResult = exports.FavoriteTimelineResponse = exports.DataProviderTypeEnum = exports.DataProviderType = exports.DataProviderResult = exports.DataProviderQueryMatch = exports.ColumnHeaderResult = exports.BarePinnedEvent = exports.BareNoteWithoutExternalRefs = exports.BareNote = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Shared Timeline Components
 *   version: not applicable
 */

/**
 * The type of Timeline.
 */

const TimelineType = exports.TimelineType = _zod.z.enum(['default', 'template']);
const TimelineTypeEnum = exports.TimelineTypeEnum = TimelineType.enum;

/**
 * The type of data provider.
 */

const DataProviderType = exports.DataProviderType = _zod.z.enum(['default', 'template']);
const DataProviderTypeEnum = exports.DataProviderTypeEnum = DataProviderType.enum;

/**
 * The type of the timeline template.
 */

const TemplateTimelineType = exports.TemplateTimelineType = _zod.z.enum(['elastic', 'custom']);
const TemplateTimelineTypeEnum = exports.TemplateTimelineTypeEnum = TemplateTimelineType.enum;
const ColumnHeaderResult = exports.ColumnHeaderResult = _zod.z.object({
  aggregatable: _zod.z.boolean().nullable().optional(),
  category: _zod.z.string().nullable().optional(),
  columnHeaderType: _zod.z.string().nullable().optional(),
  description: _zod.z.string().nullable().optional(),
  example: _zod.z.string().nullable().optional(),
  indexes: _zod.z.array(_zod.z.string()).nullable().optional(),
  id: _zod.z.string().nullable().optional(),
  name: _zod.z.string().nullable().optional(),
  placeholder: _zod.z.string().nullable().optional(),
  searchable: _zod.z.boolean().nullable().optional(),
  type: _zod.z.string().nullable().optional()
});
const QueryMatchResult = exports.QueryMatchResult = _zod.z.object({
  field: _zod.z.string().nullable().optional(),
  displayField: _zod.z.string().nullable().optional(),
  value: _zod.z.union([_zod.z.string().nullable(), _zod.z.array(_zod.z.string()).nullable()]).optional(),
  displayValue: _zod.z.string().nullable().optional(),
  operator: _zod.z.string().nullable().optional()
});
const DataProviderQueryMatch = exports.DataProviderQueryMatch = _zod.z.object({
  enabled: _zod.z.boolean().nullable().optional(),
  excluded: _zod.z.boolean().nullable().optional(),
  id: _zod.z.string().nullable().optional(),
  kqlQuery: _zod.z.string().nullable().optional(),
  name: _zod.z.string().nullable().optional(),
  queryMatch: QueryMatchResult.nullable().optional(),
  type: DataProviderType.nullable().optional()
});
const DataProviderResult = exports.DataProviderResult = _zod.z.object({
  and: _zod.z.array(DataProviderQueryMatch).nullable().optional(),
  enabled: _zod.z.boolean().nullable().optional(),
  excluded: _zod.z.boolean().nullable().optional(),
  id: _zod.z.string().nullable().optional(),
  kqlQuery: _zod.z.string().nullable().optional(),
  name: _zod.z.string().nullable().optional(),
  queryMatch: QueryMatchResult.nullable().optional(),
  type: DataProviderType.nullable().optional()
});

/**
 * Identifies the available row renderers
 */

const RowRendererId = exports.RowRendererId = _zod.z.enum(['alert', 'alerts', 'auditd', 'auditd_file', 'library', 'netflow', 'plain', 'registry', 'suricata', 'system', 'system_dns', 'system_endgame_process', 'system_file', 'system_fim', 'system_security_event', 'system_socket', 'threat_match', 'zeek']);
const RowRendererIdEnum = exports.RowRendererIdEnum = RowRendererId.enum;

/**
 * Indicates when and who marked a Timeline as a favorite.
 */

const FavoriteTimelineResult = exports.FavoriteTimelineResult = _zod.z.object({
  fullName: _zod.z.string().nullable().optional(),
  userName: _zod.z.string().nullable().optional(),
  favoriteDate: _zod.z.number().nullable().optional()
});
const FilterTimelineResult = exports.FilterTimelineResult = _zod.z.object({
  exists: _zod.z.string().nullable().optional(),
  meta: _zod.z.object({
    alias: _zod.z.string().nullable().optional(),
    controlledBy: _zod.z.string().nullable().optional(),
    disabled: _zod.z.boolean().nullable().optional(),
    field: _zod.z.string().nullable().optional(),
    formattedValue: _zod.z.string().nullable().optional(),
    index: _zod.z.string().nullable().optional(),
    key: _zod.z.string().nullable().optional(),
    negate: _zod.z.boolean().nullable().optional(),
    params: _zod.z.string().nullable().optional(),
    type: _zod.z.string().nullable().optional(),
    value: _zod.z.string().nullable().optional()
  }).nullable().optional(),
  match_all: _zod.z.string().nullable().optional(),
  missing: _zod.z.string().nullable().optional(),
  query: _zod.z.string().nullable().optional(),
  range: _zod.z.string().nullable().optional(),
  script: _zod.z.string().nullable().optional()
});

/**
 * KQL bar query.
 */

const SerializedFilterQueryResult = exports.SerializedFilterQueryResult = _zod.z.object({
  filterQuery: _zod.z.object({
    kuery: _zod.z.object({
      kind: _zod.z.string().nullable().optional(),
      expression: _zod.z.string().nullable().optional()
    }).nullable().optional(),
    serializedQuery: _zod.z.string().nullable().optional()
  }).nullable().optional()
});

/**
 * Object indicating how rows are sorted in the Timeline's grid
 */

const SortObject = exports.SortObject = _zod.z.object({
  columnId: _zod.z.string().nullable().optional(),
  columnType: _zod.z.string().nullable().optional(),
  sortDirection: _zod.z.string().nullable().optional()
});
const Sort = exports.Sort = _zod.z.union([SortObject, _zod.z.array(SortObject)]);

/**
 * The status of the Timeline.
 */

const TimelineStatus = exports.TimelineStatus = _zod.z.enum(['active', 'draft', 'immutable']);
const TimelineStatusEnum = exports.TimelineStatusEnum = TimelineStatus.enum;
const SavedTimeline = exports.SavedTimeline = _zod.z.object({
  /**
   * The Timeline's columns
   */
  columns: _zod.z.array(ColumnHeaderResult).nullable().optional(),
  /**
   * The time the Timeline was created, using a 13-digit Epoch timestamp.
   */
  created: _zod.z.number().nullable().optional(),
  /**
   * The user who created the Timeline.
   */
  createdBy: _zod.z.string().nullable().optional(),
  /**
   * Object containing query clauses
   */
  dataProviders: _zod.z.array(DataProviderResult).nullable().optional(),
  /**
   * ID of the Timeline's Data View
   */
  dataViewId: _zod.z.string().nullable().optional(),
  /**
   * The Timeline's search period.
   */
  dateRange: _zod.z.object({
    end: _zod.z.union([_zod.z.string().nullable(), _zod.z.number().nullable()]).optional(),
    start: _zod.z.union([_zod.z.string().nullable(), _zod.z.number().nullable()]).optional()
  }).nullable().optional(),
  /**
   * The Timeline's description
   */
  description: _zod.z.string().nullable().optional(),
  /**
   * EQL query that is used in the correlation tab
   */
  eqlOptions: _zod.z.object({
    eventCategoryField: _zod.z.string().nullable().optional(),
    query: _zod.z.string().nullable().optional(),
    size: _zod.z.union([_zod.z.string().nullable(), _zod.z.number().nullable()]).optional(),
    tiebreakerField: _zod.z.string().nullable().optional(),
    timestampField: _zod.z.string().nullable().optional()
  }).nullable().optional(),
  /**
   * Event types displayed in the Timeline
   */
  eventType: _zod.z.string().nullable().optional(),
  /**
   * A list of row renderers that should not be used when in `Event renderers` mode
   */
  excludedRowRendererIds: _zod.z.array(RowRendererId).nullable().optional(),
  favorite: _zod.z.array(FavoriteTimelineResult).nullable().optional(),
  /**
   * A list of filters that should be applied to the query
   */
  filters: _zod.z.array(FilterTimelineResult).nullable().optional(),
  /**
   * Indicates whether the KQL bar filters the query results or searches for additional results, where:
   * `filter`: filters query results
   * `search`: displays additional search results
   */
  kqlMode: _zod.z.string().nullable().optional(),
  kqlQuery: SerializedFilterQueryResult.nullable().optional(),
  /**
   * A list of index names to use in the query (e.g. when the default data view has been modified)
   */
  indexNames: _zod.z.array(_zod.z.string()).nullable().optional(),
  /**
   * The ID of the saved search that is used in the ES|QL tab
   */
  savedSearchId: _zod.z.string().nullable().optional(),
  /**
   * The ID of the saved query that might be used in the Query tab
   */
  savedQueryId: _zod.z.string().nullable().optional(),
  sort: Sort.nullable().optional(),
  status: TimelineStatus.nullable().optional(),
  /**
   * The Timeline's title.
   */
  title: _zod.z.string().nullable().optional(),
  /**
   * A unique ID (UUID) for Timeline templates. For Timelines, the value is `null`.
   */
  templateTimelineId: _zod.z.string().nullable().optional(),
  /**
   * Timeline template version number. For Timelines, the value is `null`.
   */
  templateTimelineVersion: _zod.z.number().nullable().optional(),
  timelineType: TimelineType.nullable().optional(),
  /**
   * The last time the Timeline was updated, using a 13-digit Epoch timestamp
   */
  updated: _zod.z.number().nullable().optional(),
  /**
   * The user who last updated the Timeline
   */
  updatedBy: _zod.z.string().nullable().optional()
});
const SavedTimelineWithSavedObjectId = exports.SavedTimelineWithSavedObjectId = SavedTimeline.merge(_zod.z.object({
  /**
   * The `savedObjectId` of the Timeline or Timeline template
   */
  savedObjectId: _zod.z.string(),
  /**
   * The version of the Timeline or Timeline template
   */
  version: _zod.z.string()
}));
const NoteCreatedAndUpdatedMetadata = exports.NoteCreatedAndUpdatedMetadata = _zod.z.object({
  /**
   * The time the note was created, using a 13-digit Epoch timestamp.
   */
  created: _zod.z.number().nullable().optional(),
  /**
   * The user who created the note.
   */
  createdBy: _zod.z.string().nullable().optional(),
  /**
   * The last time the note was updated, using a 13-digit Epoch timestamp
   */
  updated: _zod.z.number().nullable().optional(),
  /**
   * The user who last updated the note
   */
  updatedBy: _zod.z.string().nullable().optional()
});
const BareNote = exports.BareNote = NoteCreatedAndUpdatedMetadata.merge(_zod.z.object({
  /**
   * The `_id` of the associated event for this note.
   */
  eventId: _zod.z.string().nullable().optional(),
  /**
   * The text of the note
   */
  note: _zod.z.string().nullable().optional(),
  /**
   * The `savedObjectId` of the Timeline that this note is associated with
   */
  timelineId: _zod.z.string()
}));
const Note = exports.Note = BareNote.merge(_zod.z.object({
  /**
   * The `savedObjectId` of the note
   */
  noteId: _zod.z.string(),
  /**
   * The version of the note
   */
  version: _zod.z.string()
}));
const PinnedEventCreatedAndUpdatedMetadata = exports.PinnedEventCreatedAndUpdatedMetadata = _zod.z.object({
  /**
   * The time the pinned event was created, using a 13-digit Epoch timestamp.
   */
  created: _zod.z.number().nullable().optional(),
  /**
   * The user who created the pinned event.
   */
  createdBy: _zod.z.string().nullable().optional(),
  /**
   * The last time the pinned event was updated, using a 13-digit Epoch timestamp
   */
  updated: _zod.z.number().nullable().optional(),
  /**
   * The user who last updated the pinned event
   */
  updatedBy: _zod.z.string().nullable().optional()
});
const BarePinnedEvent = exports.BarePinnedEvent = PinnedEventCreatedAndUpdatedMetadata.merge(_zod.z.object({
  /**
   * The `_id` of the associated event for this pinned event.
   */
  eventId: _zod.z.string(),
  /**
   * The `savedObjectId` of the timeline that this pinned event is associated with
   */
  timelineId: _zod.z.string()
}));
const PinnedEvent = exports.PinnedEvent = BarePinnedEvent.merge(_zod.z.object({
  /**
   * The `savedObjectId` of this pinned event
   */
  pinnedEventId: _zod.z.string(),
  /**
   * The version of this pinned event
   */
  version: _zod.z.string()
}));
const TimelineResponse = exports.TimelineResponse = SavedTimeline.merge(SavedTimelineWithSavedObjectId).merge(_zod.z.object({
  /**
   * A list of all the notes that are associated to this Timeline.
   */
  eventIdToNoteIds: _zod.z.array(Note).nullable().optional(),
  /**
   * A list of all the notes that are associated to this Timeline.
   */
  notes: _zod.z.array(Note).nullable().optional(),
  /**
   * A list of all the ids of notes that are associated to this Timeline.
   */
  noteIds: _zod.z.array(_zod.z.string()).nullable().optional(),
  /**
   * A list of all the ids of pinned events that are associated to this Timeline.
   */
  pinnedEventIds: _zod.z.array(_zod.z.string()).nullable().optional(),
  /**
   * A list of all the pinned events that are associated to this Timeline.
   */
  pinnedEventsSaveObject: _zod.z.array(PinnedEvent).nullable().optional()
}));
const TimelineSavedToReturnObject = exports.TimelineSavedToReturnObject = SavedTimeline.merge(_zod.z.object({
  savedObjectId: _zod.z.string(),
  version: _zod.z.string(),
  eventIdToNoteIds: _zod.z.array(Note).nullable().optional(),
  notes: _zod.z.array(Note).nullable().optional(),
  noteIds: _zod.z.array(_zod.z.string()).nullable().optional(),
  pinnedEventIds: _zod.z.array(_zod.z.string()).nullable().optional(),
  pinnedEventsSaveObject: _zod.z.array(PinnedEvent).nullable().optional()
}));
const SavedObjectResolveOutcome = exports.SavedObjectResolveOutcome = _zod.z.enum(['exactMatch', 'aliasMatch', 'conflict']);
const SavedObjectResolveOutcomeEnum = exports.SavedObjectResolveOutcomeEnum = SavedObjectResolveOutcome.enum;
const SavedObjectResolveAliasPurpose = exports.SavedObjectResolveAliasPurpose = _zod.z.enum(['savedObjectConversion', 'savedObjectImport']);
const SavedObjectResolveAliasPurposeEnum = exports.SavedObjectResolveAliasPurposeEnum = SavedObjectResolveAliasPurpose.enum;
const ResolvedTimeline = exports.ResolvedTimeline = _zod.z.object({
  timeline: TimelineSavedToReturnObject,
  outcome: SavedObjectResolveOutcome,
  alias_target_id: _zod.z.string().optional(),
  alias_purpose: SavedObjectResolveAliasPurpose.optional()
});
const FavoriteTimelineResponse = exports.FavoriteTimelineResponse = _zod.z.object({
  savedObjectId: _zod.z.string(),
  version: _zod.z.string(),
  templateTimelineId: _zod.z.string().nullable().optional(),
  templateTimelineVersion: _zod.z.number().nullable().optional(),
  timelineType: TimelineType.optional(),
  favorite: _zod.z.array(FavoriteTimelineResult).optional()
});
const PersistTimelineResponse = exports.PersistTimelineResponse = TimelineResponse;
const BareNoteWithoutExternalRefs = exports.BareNoteWithoutExternalRefs = NoteCreatedAndUpdatedMetadata.merge(_zod.z.object({
  /**
   * The `_id` of the associated event for this note.
   */
  eventId: _zod.z.string().nullable().optional(),
  /**
   * The text of the note
   */
  note: _zod.z.string().nullable().optional(),
  /**
   * The `savedObjectId` of the timeline that this note is associated with
   */
  timelineId: _zod.z.string().optional()
}));

/**
 * The field to sort the timelines by.
 */

const SortFieldTimeline = exports.SortFieldTimeline = _zod.z.enum(['title', 'description', 'updated', 'created']);
const SortFieldTimelineEnum = exports.SortFieldTimelineEnum = SortFieldTimeline.enum;
const SortDirection = exports.SortDirection = _zod.z.enum(['asc', 'desc']);
const SortDirectionEnum = exports.SortDirectionEnum = SortDirection.enum;
const ImportTimelines = exports.ImportTimelines = SavedTimeline.merge(_zod.z.object({
  savedObjectId: _zod.z.string().nullable(),
  version: _zod.z.string().nullable(),
  pinnedEventIds: _zod.z.array(_zod.z.string()).nullable(),
  eventNotes: _zod.z.array(BareNote).nullable(),
  globalNotes: _zod.z.array(BareNote).nullable()
}));
const ImportTimelineResult = exports.ImportTimelineResult = _zod.z.object({
  /**
   * Indicates whether any of the Timelines were successfully imports
   */
  success: _zod.z.boolean().optional(),
  /**
   * The amount of successfully imported/updated Timelines
   */
  success_count: _zod.z.number().optional(),
  /**
   * The amount of successfully installed Timelines
   */
  timelines_installed: _zod.z.number().optional(),
  /**
   * The amount of successfully updated Timelines
   */
  timelines_updated: _zod.z.number().optional(),
  /**
   * The list of failed Timeline imports
   */
  errors: _zod.z.array(_zod.z.object({
    /**
     * The ID of the timeline that failed to import
     */
    id: _zod.z.string().optional(),
    /**
     * The error containing the reason why the timeline could not be imported
     */
    error: _zod.z.object({
      /**
       * The reason why the timeline could not be imported
       */
      message: _zod.z.string().optional(),
      /**
       * The HTTP status code of the error
       */
      status_code: _zod.z.number().optional()
    }).optional()
  })).optional()
});
const TimelineErrorResponse = exports.TimelineErrorResponse = _zod.z.union([_zod.z.object({
  message: _zod.z.string(),
  status_code: _zod.z.number()
}), _zod.z.object({
  message: _zod.z.string(),
  statusCode: _zod.z.number()
})]);