"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderIntegrationsLinkCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _context = require("../context");
var _links = require("../../links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderIntegrationsLinkCallout = core => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "cluster",
    title: _i18n.i18n.translate('securitySolutionPackages.integrationsCallout.title', {
      defaultMessage: 'Integrations'
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('securitySolutionPackages.integrationsCallout.body', {
    defaultMessage: 'Choose an integration to start collecting and analyzing your data.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_context.NavigationProvider, {
    core: core
  }, /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
    app: "integrations",
    path: "/browse/security",
    fill: true
  }, _i18n.i18n.translate('securitySolutionPackages.integrationsCallout.button', {
    defaultMessage: 'Browse integrations'
  })))))));
};
exports.renderIntegrationsLinkCallout = renderIntegrationsLinkCallout;