"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSiemMigrationsBaseKibanaFeature = void 0;
var _coreApplicationCommon = require("@kbn/core-application-common");
var _i18n = require("@kbn/i18n");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSiemMigrationsBaseKibanaFeature = () => ({
  id: _constants.SIEM_MIGRATIONS_FEATURE_ID,
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.linkSecuritySolutionSiemMigrationsTitle', {
    defaultMessage: 'SIEM migrations'
  }),
  order: 1500,
  category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security,
  app: [_constants.SIEM_MIGRATIONS_FEATURE_ID, 'kibana'],
  catalogue: [_constants.APP_ID],
  minimumLicense: 'enterprise',
  privileges: {
    all: {
      api: [],
      app: [_constants.SIEM_MIGRATIONS_FEATURE_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      savedObject: {
        all: [],
        read: []
      },
      ui: []
    },
    read: {
      // No read-only mode currently supported
      disabled: true,
      savedObject: {
        all: [],
        read: []
      },
      ui: []
    }
  }
});
exports.getSiemMigrationsBaseKibanaFeature = getSiemMigrationsBaseKibanaFeature;