"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIMELINE_FEATURE_ID = exports.SIEM_MIGRATIONS_FEATURE_ID = exports.SERVER_APP_ID = exports.SECURITY_SOLUTION_CASES_APP_ID = exports.SECURITY_FEATURE_ID_V3 = exports.SECURITY_FEATURE_ID_V2 = exports.NOTES_FEATURE_ID = exports.LEGACY_NOTIFICATIONS_ID = exports.CLOUD_POSTURE_APP_ID = exports.CASES_FEATURE_ID_V3 = exports.CASES_FEATURE_ID_V2 = exports.CASES_FEATURE_ID = exports.ATTACK_DISCOVERY_FEATURE_ID = exports.ASSISTANT_FEATURE_ID = exports.APP_ID = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Same as the plugin id defined by Security Solution
const APP_ID = exports.APP_ID = 'securitySolution';
const SERVER_APP_ID = exports.SERVER_APP_ID = 'siem';

// New version created in 8.18. It was previously `SERVER_APP_ID`.
const SECURITY_FEATURE_ID_V2 = exports.SECURITY_FEATURE_ID_V2 = 'siemV2';
// New version for 9.1.
const SECURITY_FEATURE_ID_V3 = exports.SECURITY_FEATURE_ID_V3 = 'siemV3';

/**
 * @deprecated deprecated in 8.17. Use CASE_FEATURE_ID_V2 instead
 */
const CASES_FEATURE_ID = exports.CASES_FEATURE_ID = 'securitySolutionCases';

// New version created in 8.17 to adopt the roles migration changes
const CASES_FEATURE_ID_V2 = exports.CASES_FEATURE_ID_V2 = 'securitySolutionCasesV2';

// New version created in 8.18 for case assignees
const CASES_FEATURE_ID_V3 = exports.CASES_FEATURE_ID_V3 = 'securitySolutionCasesV3';
const SECURITY_SOLUTION_CASES_APP_ID = exports.SECURITY_SOLUTION_CASES_APP_ID = 'securitySolutionCases';
const ASSISTANT_FEATURE_ID = exports.ASSISTANT_FEATURE_ID = 'securitySolutionAssistant';
const ATTACK_DISCOVERY_FEATURE_ID = exports.ATTACK_DISCOVERY_FEATURE_ID = 'securitySolutionAttackDiscovery';
const TIMELINE_FEATURE_ID = exports.TIMELINE_FEATURE_ID = 'securitySolutionTimeline';
const NOTES_FEATURE_ID = exports.NOTES_FEATURE_ID = 'securitySolutionNotes';
const SIEM_MIGRATIONS_FEATURE_ID = exports.SIEM_MIGRATIONS_FEATURE_ID = 'securitySolutionSiemMigrations';

// Same as the plugin id defined by Cloud Security Posture
const CLOUD_POSTURE_APP_ID = exports.CLOUD_POSTURE_APP_ID = 'csp';

/**
 * Id for the notifications alerting type
 * @deprecated Once we are confident all rules relying on side-car actions SO's have been migrated to SO references we should remove this function
 */
const LEGACY_NOTIFICATIONS_ID = exports.LEGACY_NOTIFICATIONS_ID = `siem.notifications`;