"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesSubFeaturesMapV2 = exports.getCasesBaseKibanaSubFeatureIdsV2 = void 0;
var _i18n = require("@kbn/i18n");
var _product_features_keys = require("../../product_features_keys");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Sub-features that will always be available for Security Cases
 * regardless of the product type.
 */
const getCasesBaseKibanaSubFeatureIdsV2 = () => [_product_features_keys.CasesSubFeatureId.deleteCases, _product_features_keys.CasesSubFeatureId.casesSettings, _product_features_keys.CasesSubFeatureId.createComment, _product_features_keys.CasesSubFeatureId.reopenCase];

/**
 * Defines all the Security Solution Cases subFeatures available.
 * The order of the subFeatures is the order they will be displayed
 */
exports.getCasesBaseKibanaSubFeatureIdsV2 = getCasesBaseKibanaSubFeatureIdsV2;
const getCasesSubFeaturesMapV2 = ({
  uiCapabilities,
  apiTags,
  savedObjects
}) => {
  const deleteCasesSubFeature = {
    name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.deleteSubFeatureName', {
      defaultMessage: 'Delete'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        api: apiTags.delete,
        id: 'cases_delete',
        name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.deleteSubFeatureDetails', {
          defaultMessage: 'Delete cases and comments'
        }),
        includeIn: 'all',
        savedObject: {
          all: [...savedObjects.files],
          read: [...savedObjects.files]
        },
        cases: {
          delete: [_constants.APP_ID]
        },
        ui: uiCapabilities.delete,
        replacedBy: [{
          feature: _constants.CASES_FEATURE_ID_V3,
          privileges: ['cases_delete']
        }]
      }]
    }]
  };
  const casesSettingsCasesSubFeature = {
    name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.casesSettingsSubFeatureName', {
      defaultMessage: 'Case settings'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        id: 'cases_settings',
        name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.casesSettingsSubFeatureDetails', {
          defaultMessage: 'Edit case settings'
        }),
        includeIn: 'all',
        savedObject: {
          all: [...savedObjects.files],
          read: [...savedObjects.files]
        },
        cases: {
          settings: [_constants.APP_ID]
        },
        ui: uiCapabilities.settings,
        replacedBy: [{
          feature: _constants.CASES_FEATURE_ID_V3,
          privileges: ['cases_settings']
        }]
      }]
    }]
  };

  /* The below sub features were newly added in v2 (8.17) */

  const casesAddCommentsCasesSubFeature = {
    name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.addCommentsSubFeatureName', {
      defaultMessage: 'Create comments & attachments'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        api: apiTags.createComment,
        id: 'create_comment',
        name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.addCommentsSubFeatureDetails', {
          defaultMessage: 'Add comments to cases'
        }),
        includeIn: 'all',
        savedObject: {
          all: [...savedObjects.files],
          read: [...savedObjects.files]
        },
        cases: {
          createComment: [_constants.APP_ID]
        },
        ui: uiCapabilities.createComment,
        replacedBy: [{
          feature: _constants.CASES_FEATURE_ID_V3,
          privileges: ['create_comment']
        }]
      }]
    }]
  };
  const casesreopenCaseSubFeature = {
    name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.reopenCaseSubFeatureName', {
      defaultMessage: 'Re-open'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        id: 'case_reopen',
        name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.reopenCaseSubFeatureDetails', {
          defaultMessage: 'Re-open closed cases'
        }),
        includeIn: 'all',
        savedObject: {
          all: [],
          read: []
        },
        cases: {
          reopenCase: [_constants.APP_ID]
        },
        ui: uiCapabilities.reopenCase,
        replacedBy: [{
          feature: _constants.CASES_FEATURE_ID_V3,
          privileges: ['case_reopen']
        }]
      }]
    }]
  };
  return new Map([[_product_features_keys.CasesSubFeatureId.deleteCases, deleteCasesSubFeature], [_product_features_keys.CasesSubFeatureId.casesSettings, casesSettingsCasesSubFeature], /* The below sub features were newly added in v2 (8.17) */
  [_product_features_keys.CasesSubFeatureId.createComment, casesAddCommentsCasesSubFeature], [_product_features_keys.CasesSubFeatureId.reopenCase, casesreopenCaseSubFeature]]);
};
exports.getCasesSubFeaturesMapV2 = getCasesSubFeaturesMapV2;