"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesSubFeaturesMap = exports.getCasesBaseKibanaSubFeatureIds = void 0;
var _i18n = require("@kbn/i18n");
var _product_features_keys = require("../../product_features_keys");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Sub-features that will always be available for Security Cases
 * regardless of the product type.
 */
const getCasesBaseKibanaSubFeatureIds = () => [_product_features_keys.CasesSubFeatureId.deleteCases, _product_features_keys.CasesSubFeatureId.casesSettings];

/**
 * @deprecated Use getCasesSubFeaturesMapV2 instead
 * @description - Defines all the Security Solution Cases available.
 * The order of the subFeatures is the order they will be displayed
 */
exports.getCasesBaseKibanaSubFeatureIds = getCasesBaseKibanaSubFeatureIds;
const getCasesSubFeaturesMap = ({
  uiCapabilities,
  apiTags,
  savedObjects
}) => {
  const deleteCasesSubFeature = {
    name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.deleteSubFeatureName', {
      defaultMessage: 'Delete'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        api: apiTags.delete,
        id: 'cases_delete',
        name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.deleteSubFeatureDetails', {
          defaultMessage: 'Delete cases and comments'
        }),
        includeIn: 'all',
        savedObject: {
          all: [...savedObjects.files],
          read: [...savedObjects.files]
        },
        cases: {
          delete: [_constants.APP_ID]
        },
        ui: uiCapabilities.delete,
        replacedBy: [{
          feature: _constants.CASES_FEATURE_ID_V3,
          privileges: ['cases_delete']
        }]
      }]
    }]
  };
  const casesSettingsCasesSubFeature = {
    name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.casesSettingsSubFeatureName', {
      defaultMessage: 'Case settings'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        id: 'cases_settings',
        name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.casesSettingsSubFeatureDetails', {
          defaultMessage: 'Edit case settings'
        }),
        includeIn: 'all',
        savedObject: {
          all: [...savedObjects.files],
          read: [...savedObjects.files]
        },
        cases: {
          settings: [_constants.APP_ID]
        },
        ui: uiCapabilities.settings,
        replacedBy: [{
          feature: _constants.CASES_FEATURE_ID_V3,
          privileges: ['cases_settings']
        }]
      }]
    }]
  };
  return new Map([[_product_features_keys.CasesSubFeatureId.deleteCases, deleteCasesSubFeature], [_product_features_keys.CasesSubFeatureId.casesSettings, casesSettingsCasesSubFeature]]);
};
exports.getCasesSubFeaturesMap = getCasesSubFeaturesMap;