"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.insecureClusterAlertTitle = exports.insecureClusterAlertText = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const insecureClusterAlertTitle = exports.insecureClusterAlertTitle = _i18n.i18n.translate('xpack.security.checkup.insecureClusterTitle', {
  defaultMessage: 'Your data is not secure'
});
const insecureClusterAlertText = (deps, onDismiss) => e => {
  const {
    docLinks,
    ...startServices
  } = deps;
  const AlertText = () => {
    const [persist, setPersist] = (0, _react.useState)(false);
    const enableSecurityDocLink = `${docLinks.links.security.elasticsearchEnableSecurity}?blade=kibanasecuritymessage`;
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "insecureClusterAlertText"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.checkup.insecureClusterMessage",
      defaultMessage: "Don\u2019t lose one bit. Enable our free security features."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: "persistDismissedAlertPreference",
      checked: persist,
      onChange: changeEvent => setPersist(changeEvent.target.checked),
      label: _i18n.i18n.translate('xpack.security.checkup.dontShowAgain', {
        defaultMessage: `Don't show again`
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      color: "primary",
      fill: true,
      href: enableSecurityDocLink,
      target: "_blank",
      "data-test-subj": "learnMoreButton"
    }, _i18n.i18n.translate('xpack.security.checkup.enableButtonText', {
      defaultMessage: `Enable security`
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      onClick: () => onDismiss(persist),
      "data-test-subj": "dismissAlertButton"
    }, _i18n.i18n.translate('xpack.security.checkup.dismissButtonText', {
      defaultMessage: `Dismiss`
    })))));
  };
  (0, _reactDom.render)(startServices.rendering.addContext(/*#__PURE__*/_react.default.createElement(AlertText, null)), e);
  return () => (0, _reactDom.unmountComponentAtNode)(e);
};
exports.insecureClusterAlertText = insecureClusterAlertText;