"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isUserReserved = exports.isUserDeprecated = exports.getExtendedUserDeprecationNotice = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isUserReserved = user => {
  var _user$metadata$_reser, _user$metadata;
  return (_user$metadata$_reser = (_user$metadata = user.metadata) === null || _user$metadata === void 0 ? void 0 : _user$metadata._reserved) !== null && _user$metadata$_reser !== void 0 ? _user$metadata$_reser : false;
};
exports.isUserReserved = isUserReserved;
const isUserDeprecated = user => {
  var _user$metadata$_depre, _user$metadata2;
  return (_user$metadata$_depre = (_user$metadata2 = user.metadata) === null || _user$metadata2 === void 0 ? void 0 : _user$metadata2._deprecated) !== null && _user$metadata$_depre !== void 0 ? _user$metadata$_depre : false;
};
exports.isUserDeprecated = isUserDeprecated;
const getExtendedUserDeprecationNotice = user => {
  var _user$metadata$_depre2, _user$metadata3;
  const reason = (_user$metadata$_depre2 = (_user$metadata3 = user.metadata) === null || _user$metadata3 === void 0 ? void 0 : _user$metadata3._deprecated_reason) !== null && _user$metadata$_depre2 !== void 0 ? _user$metadata$_depre2 : '';
  return _i18n.i18n.translate('xpack.security.management.users.extendedUserDeprecationNotice', {
    defaultMessage: `The {username} user is deprecated. {reason}`,
    values: {
      username: user.username,
      reason
    }
  });
};
exports.getExtendedUserDeprecationNotice = getExtendedUserDeprecationNotice;