"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegeSummary = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _privilege_summary_table = require("./privilege_summary_table");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrivilegeSummary = props => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const numberOfPrivilegeDefinitions = props.role.kibana.length;
  const flyoutSize = numberOfPrivilegeDefinitions > 5 ? 'l' : 'm';
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setIsOpen(true),
    "data-test-subj": "viewPrivilegeSummaryButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRole.privilegeSummary.viewSummaryButtonText",
    defaultMessage: "View privilege summary"
  })), isOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => setIsOpen(false),
    size: flyoutSize,
    maskProps: {
      headerZindexLocation: 'below'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRole.privilegeSummary.modalHeaderTitle",
    defaultMessage: "Privilege summary"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_privilege_summary_table.PrivilegeSummaryTable, {
    role: props.role,
    spaces: props.spaces,
    kibanaPrivileges: props.kibanaPrivileges,
    canCustomizeSubFeaturePrivileges: props.canCustomizeSubFeaturePrivileges,
    spacesApiUi: props.spacesApiUi
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setIsOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRole.privilegeSummary.closeSummaryButtonText",
    defaultMessage: "Close"
  })))));
};
exports.PrivilegeSummary = PrivilegeSummary;