"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldRuleEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _model = require("../../model");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const userFields = [{
  name: 'username'
}, {
  name: 'dn'
}, {
  name: 'groups'
}, {
  name: 'realm.name'
}];
const fieldOptions = userFields.map(f => ({
  label: f.name
}));
const comparisonOptions = {
  text: {
    id: 'text',
    defaultValue: '*'
  },
  number: {
    id: 'number',
    defaultValue: 0
  },
  null: {
    id: 'null',
    defaultValue: null
  },
  boolean: {
    id: 'boolean',
    defaultValue: true
  }
};
class FieldRuleEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "renderFieldRow", (field, ruleValue, valueIndex) => {
      const isPrimaryRow = valueIndex === 0;
      let renderAddValueButton = true;
      let rowRuleValue = ruleValue;
      if (Array.isArray(ruleValue)) {
        renderAddValueButton = ruleValue.length - 1 === valueIndex;
        rowRuleValue = ruleValue[valueIndex];
      }
      const comparisonType = this.getComparisonType(rowRuleValue);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 1
      }, isPrimaryRow ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: _i18n.i18n.translate('xpack.security.management.editRoleMapping.fieldRuleEditor.userFieldLabel', {
          defaultMessage: 'User field'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        isClearable: false,
        selectedOptions: [{
          label: field
        }],
        singleSelection: {
          asPlainText: true
        },
        onChange: this.onFieldChange,
        onCreateOption: this.onAddField,
        options: fieldOptions,
        "data-test-subj": `fieldRuleEditorField-${valueIndex} fieldRuleEditorField-${valueIndex}-combo`,
        isDisabled: this.props.readOnly
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        hasEmptyLabelSpace: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
        description: _i18n.i18n.translate('xpack.security.management.editRoleMapping.fieldRuleEditor.orLabel', {
          defaultMessage: 'or'
        }),
        value: field,
        "data-test-subj": `fieldRuleEditorField-${valueIndex} fieldRuleEditorField-${valueIndex}-expression`
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, this.renderFieldTypeInput(comparisonType.id, valueIndex)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 1
      }, this.renderFieldValueInput(comparisonType.id, rowRuleValue, valueIndex)), this.conditionallyRenderAddButton(renderAddValueButton), this.conditionallyRenderDeleteButton(valueIndex));
    });
    (0, _defineProperty2.default)(this, "conditionallyRenderAddButton", renderAddValueButton => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        hasEmptyLabelSpace: true
      }, this.props.readOnly === false && renderAddValueButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconSize: "s",
        iconType: "plusInCircle",
        onClick: this.onAddAlternateValue,
        color: "primary",
        "data-test-subj": "addAlternateValueButton",
        "aria-label": _i18n.i18n.translate('xpack.security.management.editRoleMapping.fieldRuleEditor.addAlternateValueButton', {
          defaultMessage: 'Add alternate value'
        })
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "s",
        type: "empty"
      })));
    });
    (0, _defineProperty2.default)(this, "conditionallyRenderDeleteButton", valueIndex => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 1
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        hasEmptyLabelSpace: true
      }, this.props.readOnly === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "trash",
        color: "danger",
        iconSize: "s",
        "data-test-subj": `fieldRuleEditorDeleteValue fieldRuleEditorDeleteValue-${valueIndex}`,
        "aria-label": _i18n.i18n.translate('xpack.security.management.editRoleMapping.fieldRuleEditor.deleteValueLabel', {
          defaultMessage: 'Delete value'
        }),
        onClick: () => this.onRemoveAlternateValue(valueIndex)
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "s",
        type: "empty"
      })));
    });
    (0, _defineProperty2.default)(this, "renderFieldTypeInput", (inputType, valueIndex) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: _i18n.i18n.translate('xpack.security.management.editRoleMapping.fieldRuleEditor.typeFormRow', {
          defaultMessage: 'Type'
        }),
        key: valueIndex
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
        options: [{
          value: 'text',
          text: 'text'
        }, {
          value: 'number',
          text: 'number'
        }, {
          value: 'null',
          text: 'is null'
        }, {
          value: 'boolean',
          text: 'boolean'
        }],
        "data-test-subj": `fieldRuleEditorValueType-${valueIndex}`,
        value: inputType,
        onChange: e => this.onComparisonTypeChange(valueIndex, e.target.value),
        disabled: this.props.readOnly
      }));
    });
    (0, _defineProperty2.default)(this, "renderFieldValueInput", (fieldType, rowRuleValue, valueIndex) => {
      const inputField = this.getInputFieldForType(fieldType, rowRuleValue, valueIndex);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: _i18n.i18n.translate('xpack.security.management.editRoleMapping.fieldRuleEditor.valueFormRow', {
          defaultMessage: 'Value'
        }),
        key: valueIndex
      }, inputField);
    });
    (0, _defineProperty2.default)(this, "getInputFieldForType", (fieldType, rowRuleValue, valueIndex) => {
      const isNullValue = rowRuleValue === null;
      const commonProps = {
        'data-test-subj': `fieldRuleEditorValue-${valueIndex}`
      };
      switch (fieldType) {
        case 'boolean':
          return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, (0, _extends2.default)({}, commonProps, {
            value: rowRuleValue === null || rowRuleValue === void 0 ? void 0 : rowRuleValue.toString(),
            onChange: this.onBooleanValueChange(valueIndex),
            options: [{
              value: 'true',
              text: 'true'
            }, {
              value: 'false',
              text: 'false'
            }],
            disabled: this.props.readOnly
          }));
        case 'text':
        case 'null':
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, commonProps, {
            value: isNullValue ? '-- null --' : rowRuleValue,
            onChange: this.onValueChange(valueIndex),
            disabled: isNullValue || this.props.readOnly
          }));
        case 'number':
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
            "data-test-subj": `fieldRuleEditorValue-${valueIndex}`,
            value: rowRuleValue,
            onChange: this.onNumericValueChange(valueIndex),
            disabled: this.props.readOnly
          });
        default:
          throw new Error(`Unsupported input field type: ${fieldType}`);
      }
    });
    (0, _defineProperty2.default)(this, "onAddAlternateValue", () => {
      const {
        field,
        value
      } = this.props.rule;
      const nextValue = Array.isArray(value) ? [...value] : [value];
      nextValue.push('*');
      this.props.onChange(new _model.FieldRule(field, nextValue));
    });
    (0, _defineProperty2.default)(this, "onRemoveAlternateValue", index => {
      const {
        field,
        value
      } = this.props.rule;
      if (!Array.isArray(value) || value.length === 1) {
        // Only one value left. Delete entire rule instead.
        this.props.onDelete();
        return;
      }
      const nextValue = [...value];
      nextValue.splice(index, 1);
      this.props.onChange(new _model.FieldRule(field, nextValue));
    });
    (0, _defineProperty2.default)(this, "onFieldChange", ([newField]) => {
      if (!newField) {
        return;
      }
      const {
        value
      } = this.props.rule;
      this.props.onChange(new _model.FieldRule(newField.label, value));
    });
    (0, _defineProperty2.default)(this, "onAddField", newField => {
      const {
        value
      } = this.props.rule;
      this.props.onChange(new _model.FieldRule(newField, value));
    });
    (0, _defineProperty2.default)(this, "onValueChange", index => e => {
      const {
        field,
        value
      } = this.props.rule;
      let nextValue;
      if (Array.isArray(value)) {
        nextValue = [...value];
        nextValue.splice(index, 1, e.target.value);
      } else {
        nextValue = e.target.value;
      }
      this.props.onChange(new _model.FieldRule(field, nextValue));
    });
    (0, _defineProperty2.default)(this, "onNumericValueChange", index => e => {
      const {
        field,
        value
      } = this.props.rule;
      let nextValue;
      if (Array.isArray(value)) {
        nextValue = [...value];
        nextValue.splice(index, 1, parseFloat(e.target.value));
      } else {
        nextValue = parseFloat(e.target.value);
      }
      this.props.onChange(new _model.FieldRule(field, nextValue));
    });
    (0, _defineProperty2.default)(this, "onBooleanValueChange", index => e => {
      const boolValue = e.target.value === 'true';
      const {
        field,
        value
      } = this.props.rule;
      let nextValue;
      if (Array.isArray(value)) {
        nextValue = [...value];
        nextValue.splice(index, 1, boolValue);
      } else {
        nextValue = boolValue;
      }
      this.props.onChange(new _model.FieldRule(field, nextValue));
    });
    (0, _defineProperty2.default)(this, "onComparisonTypeChange", (index, newType) => {
      const comparison = comparisonOptions[newType];
      if (!comparison) {
        throw new Error(`Unexpected comparison type: ${newType}`);
      }
      const {
        field,
        value
      } = this.props.rule;
      let nextValue = value;
      if (Array.isArray(value)) {
        nextValue = [...value];
        nextValue.splice(index, 1, comparison.defaultValue);
      } else {
        nextValue = comparison.defaultValue;
      }
      this.props.onChange(new _model.FieldRule(field, nextValue));
    });
  }
  render() {
    const {
      field,
      value
    } = this.props.rule;
    const content = Array.isArray(value) ? value.map((v, index) => this.renderFieldRow(field, value, index)) : [this.renderFieldRow(field, value, 0)];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, content.map((row, index) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: index
      }, row);
    }));
  }
  getComparisonType(ruleValue) {
    const valueType = typeof ruleValue;
    if (valueType === 'string' || valueType === 'undefined') {
      return comparisonOptions.text;
    }
    if (valueType === 'number') {
      return comparisonOptions.number;
    }
    if (valueType === 'boolean') {
      return comparisonOptions.boolean;
    }
    if (ruleValue === null) {
      return comparisonOptions.null;
    }
    throw new Error(`Unable to detect comparison type for rule value [${ruleValue}]`);
  }
}
exports.FieldRuleEditor = FieldRuleEditor;
(0, _defineProperty2.default)(FieldRuleEditor, "defaultProps", {
  readOnly: false
});