"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APIKeysGridPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _public = require("@kbn/es-ui-shared-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _securityApiKeyManagement = require("@kbn/security-api-key-management");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _api_keys_empty_prompt = require("./api_keys_empty_prompt");
var _api_keys_table = require("./api_keys_table");
var _invalidate_provider = require("./invalidate_provider");
var _breadcrumb = require("../../../components/breadcrumb");
var _use_capabilities = require("../../../components/use_capabilities");
var _use_current_user = require("../../../components/use_current_user");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_TABLE_STATE = {
  query: _eui.EuiSearchBar.Query.MATCH_ALL,
  sort: {
    field: 'creation',
    direction: 'desc'
  },
  from: 0,
  size: 25,
  filters: {}
};
const PLUS_SIGN_REGEX = /[+]/g;
const APIKeysGridPage = () => {
  const {
    services
  } = (0, _public2.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  const authc = (0, _use_current_user.useAuthentication)();
  const [createdApiKey, setCreatedApiKey] = (0, _react.useState)();
  const [openedApiKey, setOpenedApiKey] = (0, _react.useState)();
  const readOnly = !(0, _use_capabilities.useCapabilities)('api_keys').save;
  const [tableState, setTableState] = (0, _react.useState)(DEFAULT_TABLE_STATE);
  const [state, queryApiKeysAndAggregations] = (0, _useAsyncFn.default)(tableStateArgs => {
    var _queryContainer$bool;
    const queryContainer = _eui.EuiSearchBar.Query.toESQuery(tableStateArgs.query);

    // Enhance the query to support partial matches for name and owner field
    if ((_queryContainer$bool = queryContainer.bool) !== null && _queryContainer$bool !== void 0 && _queryContainer$bool.must) {
      queryContainer.bool.must = queryContainer.bool.must.map(clause => {
        if (clause.simple_query_string) {
          var _clause$simple_query_;
          // Add wildcard to support partial matches
          const rawQuery = String((_clause$simple_query_ = clause.simple_query_string.query) !== null && _clause$simple_query_ !== void 0 ? _clause$simple_query_ : '');
          const wildCardQuery = rawQuery.replace(PLUS_SIGN_REGEX, '');
          return {
            bool: {
              should: [clause, {
                wildcard: {
                  name: {
                    value: `*${wildCardQuery}*`,
                    case_insensitive: true
                  }
                }
              }, {
                wildcard: {
                  username: {
                    value: `*${wildCardQuery}*`,
                    case_insensitive: true
                  }
                }
              }]
            }
          };
        }
        return clause;
      });
    }
    const requestBody = {
      ...tableStateArgs,
      query: queryContainer
    };
    return Promise.all([new _securityApiKeyManagement.APIKeysAPIClient(services.http).queryApiKeys(requestBody), authc.getCurrentUser()]);
  }, []);
  const resetQueryOnError = () => {
    setTableState(DEFAULT_TABLE_STATE);
    queryApiKeysAndAggregations(DEFAULT_TABLE_STATE);
  };
  const onTableChange = ({
    page,
    sort
  }) => {
    const newState = {
      ...tableState,
      from: (page === null || page === void 0 ? void 0 : page.index) * (page === null || page === void 0 ? void 0 : page.size),
      size: page === null || page === void 0 ? void 0 : page.size,
      sort: sort !== null && sort !== void 0 ? sort : tableState.sort
    };
    setTableState(newState);
    queryApiKeysAndAggregations(newState);
  };
  const onSearchChange = args => {
    if (!args.error) {
      const newState = {
        ...tableState,
        query: args.query
      };
      setTableState(newState);
      queryApiKeysAndAggregations(newState);
    }
  };
  const onFilterChange = filters => {
    const newState = {
      ...tableState,
      filters: {
        ...tableState.filters,
        ...filters
      }
    };
    setTableState(newState);
    queryApiKeysAndAggregations(newState);
  };
  (0, _react.useEffect)(() => {
    queryApiKeysAndAggregations(DEFAULT_TABLE_STATE);
  }, []); // eslint-disable-line react-hooks/exhaustive-deps

  if (!state.value) {
    if (state.loading) {
      return /*#__PURE__*/_react.default.createElement(_public.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.apiKeys.table.loadingApiKeysDescription",
        defaultMessage: "Loading API keys\u2026"
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_api_keys_empty_prompt.ApiKeysEmptyPrompt, {
      error: state.error
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "refresh",
      onClick: () => queryApiKeysAndAggregations(tableState)
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accountManagement.apiKeys.retryButton",
      defaultMessage: "Try again"
    })));
  }
  const [{
    aggregations,
    canManageApiKeys,
    apiKeys,
    canManageOwnApiKeys,
    canManageCrossClusterApiKeys,
    aggregationTotal: totalKeys,
    total: filteredItemTotal,
    queryError
  }, currentUser] = state.value;
  const categorizedApiKeys = !queryError ? apiKeys.map(apiKey => apiKey) : [];
  const displayedItemCount = Math.min(filteredItemTotal, totalKeys, _api_keys_table.MAX_PAGINATED_ITEMS);
  const pagination = {
    pageIndex: tableState.from / tableState.size,
    pageSize: tableState.size,
    totalItemCount: displayedItemCount,
    pageSizeOptions: [25, 50, 100]
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/create"
  }, /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
    text: _i18n.i18n.translate('xpack.security.management.apiKeys.createBreadcrumb', {
      defaultMessage: 'Create'
    }),
    href: "/create"
  }, /*#__PURE__*/_react.default.createElement(_securityApiKeyManagement.ApiKeyFlyout, {
    onSuccess: createApiKeyResponse => {
      history.push({
        pathname: '/'
      });
      setCreatedApiKey(createApiKeyResponse);
      queryApiKeysAndAggregations(tableState);
    },
    onCancel: () => history.push({
      pathname: '/'
    }),
    canManageCrossClusterApiKeys: canManageCrossClusterApiKeys,
    currentUser: currentUser,
    isLoadingCurrentUser: state.loading,
    readOnly: readOnly
  }))), openedApiKey && /*#__PURE__*/_react.default.createElement(_securityApiKeyManagement.ApiKeyFlyout, {
    onSuccess: () => {
      services.notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.security.management.apiKeys.updateSuccessMessage', {
          defaultMessage: "Updated API key ''{name}''",
          values: {
            name: openedApiKey.name
          }
        }),
        'data-test-subj': 'updateApiKeySuccessToast'
      });
      setOpenedApiKey(undefined);
      queryApiKeysAndAggregations(DEFAULT_TABLE_STATE);
    },
    onCancel: () => setOpenedApiKey(undefined),
    apiKey: openedApiKey,
    readOnly: readOnly,
    canManageCrossClusterApiKeys: canManageCrossClusterApiKeys,
    currentUser: currentUser,
    isLoadingCurrentUser: state.loading
  }), totalKeys === 0 ? /*#__PURE__*/_react.default.createElement(_api_keys_empty_prompt.ApiKeysEmptyPrompt, {
    readOnly: readOnly
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public2.reactRouterNavigate)(history, '/create'), {
    fill: true,
    iconType: "plusInCircleFilled",
    "data-test-subj": "apiKeysCreatePromptButton"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.apiKeys.table.createButton",
    defaultMessage: "Create API key"
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.apiKeysTitle",
      defaultMessage: "API keys"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.apiKeysAllDescription",
      defaultMessage: "Allow external services to access the Elastic Stack on behalf of a user."
    }),
    rightSideItems: !readOnly ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public2.reactRouterNavigate)(history, '/create'), {
      fill: true,
      iconType: "plusInCircleFilled",
      "data-test-subj": "apiKeysCreateTableButton"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.createButton",
      defaultMessage: "Create API key"
    }))] : undefined,
    paddingSize: "none",
    bottomBorder: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    paddingSize: "none"
  }, createdApiKey && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_securityApiKeyManagement.ApiKeyCreatedCallout, {
    createdApiKey: createdApiKey
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), canManageOwnApiKeys && !canManageApiKeys ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeys.table.manageOwnKeysWarning",
      defaultMessage: "You only have permission to manage your own API keys."
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : undefined, /*#__PURE__*/_react.default.createElement(_invalidate_provider.InvalidateProvider, {
    isAdmin: canManageApiKeys,
    notifications: services.notifications,
    apiKeysAPIClient: new _securityApiKeyManagement.APIKeysAPIClient(services.http)
  }, invalidateApiKeyPrompt => /*#__PURE__*/_react.default.createElement(_api_keys_table.ApiKeysTable, {
    apiKeys: categorizedApiKeys,
    onClick: apiKey => setOpenedApiKey(apiKey),
    query: tableState.query,
    queryFilters: tableState.filters,
    onDelete: apiKeysToDelete => invalidateApiKeyPrompt(apiKeysToDelete.map(({
      name,
      id
    }) => ({
      name,
      id
    })), () => queryApiKeysAndAggregations(tableState)),
    currentUser: currentUser,
    createdApiKey: createdApiKey,
    canManageCrossClusterApiKeys: canManageCrossClusterApiKeys,
    canManageApiKeys: canManageApiKeys,
    canManageOwnApiKeys: canManageOwnApiKeys,
    readOnly: readOnly,
    loading: state.loading,
    totalItemCount: filteredItemTotal,
    pagination: pagination,
    onTableChange: onTableChange,
    onSearchChange: onSearchChange,
    onFilterChange: onFilterChange,
    aggregations: aggregations,
    sortingOptions: tableState.sort,
    queryErrors: queryError,
    resetQuery: resetQueryOnError
  })))));
};
exports.APIKeysGridPage = APIKeysGridPage;