"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryRulesSetsSearch = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _constants = require("../../analytics/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryRulesSetsSearch = ({
  searchKey,
  setSearchKey
}) => {
  const useTracker = (0, _use_usage_tracker.useUsageTracker)();
  const onSearch = (0, _react.useCallback)(newSearch => {
    var _useTracker$load;
    useTracker === null || useTracker === void 0 ? void 0 : (_useTracker$load = useTracker.load) === null || _useTracker$load === void 0 ? void 0 : _useTracker$load.call(useTracker, _constants.AnalyticsEvents.rulesetSearched);
    const trimSearch = newSearch.trim();
    setSearchKey(trimSearch);
  }, [setSearchKey, useTracker]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "aria-label": "Search query rules sets",
    placeholder: "Search",
    onChange: e => setSearchKey(e.target.value),
    onSearch: onSearch,
    value: searchKey,
    "data-test-subj": "searchFieldQueryRulesSets"
  });
};
exports.QueryRulesSetsSearch = QueryRulesSetsSearch;