"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSavedPlaygroundParameters = void 0;
var _reactRouterDom = require("react-router-dom");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSavedPlaygroundParameters = () => {
  const {
    playgroundId,
    pageMode,
    viewMode
  } = (0, _reactRouterDom.useParams)();
  return {
    playgroundId,
    pageMode,
    viewMode: viewMode !== null && viewMode !== void 0 ? viewMode : _types.PlaygroundViewMode.preview
  };
};
exports.useSavedPlaygroundParameters = useSavedPlaygroundParameters;