"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryFieldsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../common/doc_links");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isQueryFieldSelected = (queryFields, index, field) => {
  var _queryFields$index;
  return Boolean((_queryFields$index = queryFields[index]) === null || _queryFields$index === void 0 ? void 0 : _queryFields$index.includes(field));
};
const QueryFieldsPanel = ({
  customizedQuery,
  index,
  indexFields,
  updateFields,
  queryFields
}) => {
  const queryTableFields = (0, _react.useMemo)(() => [...indexFields.semantic_fields, ...indexFields.elser_query_fields, ...indexFields.dense_vector_query_fields, ...indexFields.bm25_query_fields].map(field => ({
    name: typeof field === 'string' ? field : field.field,
    checked: isQueryFieldSelected(queryFields, index, typeof field === 'string' ? field : field.field)
  })), [index, indexFields, queryFields]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: false,
    hasShadow: false,
    hasBorder: true,
    "data-test-subj": `${index}-query-fields-panel`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: index,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, index)),
    initialIsOpen: true,
    "data-test-subj": `${index}-fieldsAccordion`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableCaption: _i18n.i18n.translate('xpack.searchPlayground.viewQuery.flyout.table.caption', {
      defaultMessage: 'Query Model table'
    }),
    items: queryTableFields,
    rowHeader: "name",
    columns: [{
      field: 'name',
      name: _i18n.i18n.translate('xpack.searchPlayground.viewQuery.flyout.table.column.field.name', {
        defaultMessage: 'Field'
      }),
      'data-test-subj': 'fieldName'
    }, {
      field: 'checked',
      name: _i18n.i18n.translate('xpack.searchPlayground.viewQuery.flyout.table.column.enabled.name', {
        defaultMessage: 'Enabled'
      }),
      align: 'right',
      render: (checked, field) => {
        if (customizedQuery) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: _i18n.i18n.translate('xpack.searchPlayground.viewQuery.sidePanel.fieldSelection.customized.warning.tooltip', {
              defaultMessage: 'Field selection is not supported with a user-customized query'
            })
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
            showLabel: false,
            label: field.name,
            disabled: true,
            checked: false,
            onChange: () => {},
            compressed: true,
            "data-test-subj": `field-${field.name}-${checked}`
          }));
        }
        return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
          showLabel: false,
          label: field.name,
          checked: checked,
          onChange: e => updateFields(index, field.name, e.target.checked),
          compressed: true,
          "data-test-subj": `field-${field.name}-${checked}`
        });
      }
    }]
  }), indexFields.skipped_fields > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    "data-test-subj": `${index}-skippedFields`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "eyeClosed"
  }), ` `, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.flyout.hiddenFields",
    defaultMessage: "{skippedFields} fields are hidden.",
    values: {
      skippedFields: indexFields.skipped_fields
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.hiddenFields,
    target: "_blank",
    "data-test-subj": "hidden-fields-documentation-link"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.flyout.learnMoreLink",
    defaultMessage: "Learn more."
  })))))));
};
exports.QueryFieldsPanel = QueryFieldsPanel;