"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Playground = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactHookForm = require("react-hook-form");
var _common = require("../../common");
var _search_query_mode = require("./query_mode/search_query_mode");
var _chat_setup_page = require("./setup_page/chat_setup_page");
var _header = require("./header");
var _use_load_connectors = require("../hooks/use_load_connectors");
var _types = require("../types");
var _chat = require("./chat");
var _search_mode = require("./search_mode/search_mode");
var _search_playground_setup_page = require("./setup_page/search_playground_setup_page");
var _use_show_setup_page = require("../hooks/use_show_setup_page");
var _use_validate_playground_view_modes = require("../hooks/use_validate_playground_view_modes");
var _use_kibana = require("../hooks/use_kibana");
var _use_playground_parameters = require("../hooks/use_playground_parameters");
var _use_search_playground_feature_flag = require("../hooks/use_search_playground_feature_flag");
var _routes = require("../routes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Playground = ({
  showDocs = false
}) => {
  (0, _use_validate_playground_view_modes.useValidatePlaygroundViewModes)();
  const isSearchModeEnabled = (0, _use_search_playground_feature_flag.useSearchPlaygroundFeatureFlag)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    pageMode,
    viewMode
  } = (0, _use_playground_parameters.usePlaygroundParameters)();
  const {
    application
  } = (0, _use_kibana.useKibana)().services;
  const {
    data: connectors
  } = (0, _use_load_connectors.useLoadConnectors)();
  const hasSelectedIndices = Boolean((0, _reactHookForm.useWatch)({
    name: _types.PlaygroundFormFields.indices
  }).length);
  const navigateToView = (0, _react.useCallback)((page, view, searchParams) => {
    let path = view && view !== _types.PlaygroundViewMode.preview ? `/${page}/${view}` : `/${page}`;
    if (searchParams) {
      path += searchParams;
    }
    application.navigateToApp(_common.PLUGIN_ID, {
      path
    });
  }, [application]);
  const handleModeChange = id => navigateToView(pageMode, id, location.search);
  const handlePageModeChange = mode => navigateToView(mode, viewMode, location.search);
  const {
    showSetupPage
  } = (0, _use_show_setup_page.useShowSetupPage)({
    hasSelectedIndices,
    hasConnectors: Boolean(connectors === null || connectors === void 0 ? void 0 : connectors.length)
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header.Header, {
    pageMode: pageMode,
    viewMode: viewMode,
    showDocs: showDocs,
    onModeChange: handleModeChange,
    isActionsDisabled: showSetupPage,
    onSelectPageModeChange: handlePageModeChange
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, showSetupPage ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_PLAYGROUND_CHAT_PATH,
    component: _chat_setup_page.ChatSetupPage
  }), isSearchModeEnabled && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_PLAYGROUND_SEARCH_PATH,
    component: _search_playground_setup_page.SearchPlaygroundSetupPage
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.SEARCH_PLAYGROUND_CHAT_PATH,
    component: _chat.Chat
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.PLAYGROUND_CHAT_QUERY_PATH,
    render: () => /*#__PURE__*/_react.default.createElement(_search_query_mode.SearchQueryMode, {
      pageMode: pageMode
    })
  }), isSearchModeEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.SEARCH_PLAYGROUND_SEARCH_PATH,
    component: _search_mode.SearchMode
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.PLAYGROUND_SEARCH_QUERY_PATH,
    render: () => /*#__PURE__*/_react.default.createElement(_search_query_mode.SearchQueryMode, {
      pageMode: pageMode
    })
  })))));
};
exports.Playground = Playground;