"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TokenEstimateTooltip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactHookForm = require("react-hook-form");
var _doc_links = require("../../../common/doc_links");
var _use_llms_models = require("../../hooks/use_llms_models");
var _types = require("../../types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TokenEstimateTooltip = ({
  context,
  total,
  clipped
}) => {
  const [showTooltip, setShowTooltip] = (0, _react.useState)(false);
  const models = (0, _use_llms_models.useLLMsModels)();
  const {
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const formValues = getValues(_types.PlaygroundFormFields.summarizationModel);
  const selectedModel = models.find(m => m.value === (formValues === null || formValues === void 0 ? void 0 : formValues.value));
  const toggleTooltip = () => {
    setShowTooltip(!showTooltip);
  };
  const normalContextMenuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'tokenEstimateTooltipId'
  });
  const modelLimit = selectedModel === null || selectedModel === void 0 ? void 0 : selectedModel.promptTokenLimit;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: normalContextMenuPopoverId,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "text",
      size: "xs",
      onClick: toggleTooltip,
      "data-test-subj": "token-tooltip-button"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.chat.message.tokenEstimateTooltip.label",
      defaultMessage: "{total}{limit} tokens sent",
      values: {
        total: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
          value: total
        })),
        limit: modelLimit ? /*#__PURE__*/_react.default.createElement("strong", null, ` /`, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
          value: modelLimit
        })) : null
      }
    })),
    isOpen: showTooltip,
    closePopover: toggleTooltip,
    panelPaddingSize: "none",
    anchorPosition: "upCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: [{
      id: 0,
      width: 300,
      items: [{
        name: /*#__PURE__*/_react.default.createElement("strong", {
          "data-test-subj": "token-tooltip-title"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.searchPlayground.chat.message.tokenEstimateTooltip.title",
          defaultMessage: "Approximate breakdown"
        }))
      }, {
        renderItem: () => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
          paddingSize: "s",
          hasShadow: false,
          "data-test-subj": "token-tooltip-breakdown-1"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
          compressed: true,
          rowGutterSize: "s",
          columnGutterSize: "s",
          listItems: [{
            description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.searchPlayground.chat.message.tokenEstimateTooltip.contextTokens",
              defaultMessage: "Context tokens"
            }),
            title: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
              value: context
            })
          }, {
            description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.searchPlayground.chat.message.tokenEstimateTooltip.instructionTokens",
              defaultMessage: "Instruction tokens"
            }),
            title: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
              value: total - context
            })
          }, ...(modelLimit ? [{
            description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
              color: "subdued"
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.searchPlayground.chat.message.tokenEstimateTooltip.modelLimit",
              defaultMessage: "Max for this model"
            })),
            title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
              color: "subdued"
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
              value: modelLimit
            }))
          }] : [])],
          type: "column",
          columnWidths: [2, 4]
        }))
      }, {
        renderItem: () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, clipped ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
          paddingSize: "s",
          hasShadow: false,
          color: "warning"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          "data-test-subj": "clipped-tokens-callout",
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.searchPlayground.chat.message.tokenEstimateTooltip.clippedTokensTitle",
            defaultMessage: "Context tokens exceed model limit"
          }),
          color: "warning",
          iconType: "info",
          size: "s"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.searchPlayground.chat.message.tokenEstimateTooltip.clippedTokensDescription",
          defaultMessage: "Approximately {clipped} tokens within your context was removed to fit within the model's limit. Learn how to {optimizeLink} to improve your model's performance and avoid clipping.",
          values: {
            clipped: /*#__PURE__*/_react.default.createElement("strong", {
              "data-test-subj": "clipped-tokens-description"
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
              value: clipped
            })),
            optimizeLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
              href: _doc_links.docLinks.retrievalOptimize,
              target: "_blank",
              "data-test-subj": "context-optimization-documentation-link"
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.searchPlayground.chat.message.tokenEstimateTooltip.optimizeYourIndex",
              defaultMessage: "optimize your context"
            }))
          }
        }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
          paddingSize: "s",
          hasShadow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _doc_links.docLinks.chatPlayground,
          target: "_blank",
          "data-test-subj": "context-optimization-documentation-link"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.searchPlayground.chat.message.tokenEstimateTooltip.learnMoreLink",
          defaultMessage: "Learn more"
        }))))
      }]
    }]
  }));
};
exports.TokenEstimateTooltip = TokenEstimateTooltip;