"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditContextPanel = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_source_indices_field = require("../../hooks/use_source_indices_field");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _types = require("../../types");
var _constants = require("../../analytics/constants");
var _context_fields_select = require("./context_fields_select");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditContextPanel = () => {
  const idPrefix = 'playground_context_doc_number';
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    fields
  } = (0, _use_source_indices_field.useSourceIndicesFields)();
  const {
    field: {
      onChange: onChangeSize,
      value: docSize
    }
  } = (0, _reactHookForm.useController)({
    name: _types.PlaygroundFormFields.docSize
  });
  const {
    field: {
      onChange: onChangeSourceFields,
      value: sourceFields
    }
  } = (0, _reactHookForm.useController)({
    name: _types.PlaygroundFormFields.sourceFields
  });
  const updateSourceField = (0, _react.useCallback)((index, contextFields) => {
    onChangeSourceFields({
      ...sourceFields,
      [index]: contextFields
    });
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.editContextFieldToggled);
  }, [onChangeSourceFields, sourceFields, usageTracker]);
  const handleDocSizeButtonGroupChange = value => {
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.editContextDocSizeChanged);
    onChangeSize(value);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "editContextPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.documentsSize.table.title",
    defaultMessage: "Documents"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.editContext.docsRetrievedCount",
    defaultMessage: "Number of documents sent"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    "data-test-subj": "documentSizeButtonGroup",
    legend: "Number of documents sent",
    isFullWidth: true,
    buttonSize: "compressed",
    options: [{
      id: `${idPrefix}-1`,
      label: '1',
      value: 1,
      'data-test-subj': `${idPrefix}-1`
    }, {
      id: `${idPrefix}-3`,
      label: '3',
      value: 3,
      'data-test-subj': `${idPrefix}-3`
    }, {
      id: `${idPrefix}-5`,
      label: '5',
      value: 5,
      'data-test-subj': `${idPrefix}-5`
    }, {
      id: `${idPrefix}-10`,
      label: '10',
      value: 10,
      'data-test-subj': `${idPrefix}-10`
    }],
    idSelected: `${idPrefix}-${docSize}`,
    onChange: (_, value) => handleDocSizeButtonGroupChange(value)
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.editContext.table.title",
    defaultMessage: "Context fields"
  })))), Object.entries(fields).map(([index, group]) => {
    var _sourceFields$index;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: index
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: index,
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_context_fields_select.ContextFieldsSelect, {
      indexName: index,
      indexFields: group,
      selectedContextFields: (_sourceFields$index = sourceFields[index]) !== null && _sourceFields$index !== void 0 ? _sourceFields$index : [],
      updateSelectedContextFields: updateSourceField
    })));
  })))));
};
exports.EditContextPanel = EditContextPanel;