"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWorkflow = void 0;
var _react = require("react");
var _searchSharedUi = require("@kbn/search-shared-ui");
var _ingest_data = require("../../../code_examples/ingest_data");
var _workflows = require("../../../code_examples/workflows");
var _create_index = require("../../../code_examples/create_index");
var _use_onboarding_data = require("../../../hooks/api/use_onboarding_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const workflowIdToCreateIndexExamples = type => {
  switch (type) {
    case 'vector':
      return _create_index.DenseVectorCodeExamples;
    case 'semantic':
      return _create_index.SemanticCodeExamples;
    default:
      return _create_index.DefaultCodeExamples;
  }
};
const workflowIdToIngestDataExamples = type => {
  switch (type) {
    case 'vector':
      return _ingest_data.DenseVectorIngestDataCodeExamples;
    case 'semantic':
      return _ingest_data.SemanticIngestDataCodeExamples;
    default:
      return _ingest_data.DefaultIngestDataCodeExamples;
  }
};
function isWorkflowId(value) {
  return value === 'default' || value === 'vector' || value === 'semantic';
}

// possible onboarding tokens now: 'general' | 'vector' | 'timeseries' | 'semantic' for serverless, 'vectorsearch' or 'search' for hosted
// note: test with http://localhost:5601/app/cloud/onboarding?next=/app/elasticsearch&onboarding_token=vector in Serverless
// http://localhost:5601/app/cloud/onboarding?next=/app/enterprise_search/overview&onboarding_token=vector in Hosted

function onboardingTokenToWorkflowId(token) {
  switch (token) {
    case 'vector':
      return 'vector';
    case 'vectorsearch':
      return 'vector';
    case 'semantic':
      return 'semantic';
    default:
      return 'default';
  }
}
const DEFAULT_WORKFLOW_ID = 'semantic';
const useWorkflow = () => {
  const localStorageWorkflow = localStorage.getItem(_searchSharedUi.WORKFLOW_LOCALSTORAGE_KEY);
  const workflowId = isWorkflowId(localStorageWorkflow) ? localStorageWorkflow : null;
  const [selectedWorkflowId, setSelectedWorkflowId] = (0, _react.useState)(workflowId || DEFAULT_WORKFLOW_ID);
  const {
    data
  } = (0, _use_onboarding_data.useOnboardingTokenQuery)();
  (0, _react.useEffect)(() => {
    if (data !== null && data !== void 0 && data.token && !localStorageWorkflow) {
      setSelectedWorkflowId(onboardingTokenToWorkflowId(data.token));
    }
  }, [data, localStorageWorkflow]);
  return {
    selectedWorkflowId,
    setSelectedWorkflowId: newWorkflowId => {
      localStorage.setItem(_searchSharedUi.WORKFLOW_LOCALSTORAGE_KEY, newWorkflowId);
      setSelectedWorkflowId(newWorkflowId);
    },
    workflow: _workflows.workflows.find(workflow => workflow.id === selectedWorkflowId),
    createIndexExamples: workflowIdToCreateIndexExamples(selectedWorkflowId),
    ingestExamples: workflowIdToIngestDataExamples(selectedWorkflowId)
  };
};
exports.useWorkflow = useWorkflow;