"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APIKeyCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchApiKeysComponents = require("@kbn/search-api-keys-components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APIKeyCallout = ({
  apiKey
}) => {
  const title = apiKey ? _i18n.i18n.translate('xpack.searchIndices.shared.codeView.apiKeyTitle', {
    defaultMessage: 'Copy your API key'
  }) : _i18n.i18n.translate('xpack.searchIndices.shared.codeView.explicitGenerate.apiKeyTitle', {
    defaultMessage: 'Create an API key'
  });
  const description = apiKey ? _i18n.i18n.translate('xpack.searchIndices.shared.codeView.apiKeyDescription', {
    defaultMessage: 'Make sure you keep it somewhere safe. You won’t be able to retrieve it later.'
  }) : _i18n.i18n.translate('xpack.searchIndices.shared.codeView.explicitGenerate.apiKeyDescription', {
    defaultMessage: 'Create an API key to connect to Elasticsearch.'
  });
  const dataTestSubj = apiKey ? 'apiKeyHasBeenGenerated' : 'apiKeyHasNotBeenGenerated';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasShadow: false,
    hasBorder: false,
    color: "subdued",
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, description)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_searchApiKeysComponents.ApiKeyForm, {
    hasTitle: false
  }));
};
exports.APIKeyCallout = APIKeyCallout;