"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuickStatsContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("./styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QuickStatsContainer = ({
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: _styles.StatsGridContainerStyle
  }, children.map((item, i) => item ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `quickstat.${i}`,
    css: (0, _styles.StatsItemStyle)(euiTheme)
  }, item) : null));
};
exports.QuickStatsContainer = QuickStatsContainer;