"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuickStat = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QuickStat = ({
  icon,
  title,
  stats,
  open,
  setOpen,
  secondaryTitle,
  iconColor,
  content,
  tooltipContent,
  statsColumnWidths,
  ...rest
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const id = (0, _eui.useGeneratedHtmlId)({
    prefix: 'formAccordion',
    suffix: title.replace(/\s/g, '_')
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, (0, _extends2.default)({
    forceState: open ? 'open' : 'closed',
    "data-test-subj": id,
    onToggle: () => setOpen(!open),
    paddingSize: "none",
    id: id,
    buttonElement: "div",
    arrowDisplay: "right"
  }, rest, {
    css: {
      '.euiAccordion__arrow': {
        marginRight: euiTheme.size.s
      },
      '.euiAccordion__triggerWrapper': {
        background: euiTheme.colors.emptyShade
      },
      '.euiAccordion__children': {
        padding: euiTheme.size.m
      }
    },
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      hasBorder: false,
      paddingSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: icon,
      color: iconColor
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h4", null, title))), secondaryTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, secondaryTitle)), tooltipContent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: tooltipContent,
      display: "block"
    }))))
  }), content ? content : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    listItems: stats,
    columnWidths: statsColumnWidths !== null && statsColumnWidths !== void 0 ? statsColumnWidths : [3, 1],
    compressed: true,
    descriptionProps: {
      color: 'subdued'
    }
  }))));
};
exports.QuickStat = QuickStat;