"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSearchExample = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../common/doc_links");
var _code_box = require("../code_box/code_box");
var _use_search_code_examples = require("../../hooks/use_search_code_examples");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexSearchExample = ({
  indexName,
  mappings,
  navigateToPlayground
}) => {
  const codeExamples = (0, _use_search_code_examples.useSearchCodeExamples)(indexName, mappings);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.indexDetail.searchExample.title",
    defaultMessage: "Search your data"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.indexDetail.searchExample.description",
    defaultMessage: "A search query finds relevant documents in your Elasticsearch data using exact matches, patterns, or similarity scoring."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.searchAPIReference,
    "data-test-subj": "",
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.indexDetail.searchExample.apiReferenceLink",
    defaultMessage: "Explore the Search API"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.indexDetail.searchExample.playground.title",
    defaultMessage: "Playground"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.indexDetail.searchExample.playground.description",
    defaultMessage: "Try out different queries and preview the results."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "search-in-playground-btn",
    onClick: navigateToPlayground,
    fullWidth: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.indexDetail.searchExample.playground.cta",
    defaultMessage: "Search in Playground"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_code_box.CodeBox, {
    "data-test-subj": "search-example-codebox",
    options: codeExamples.options,
    consoleCode: codeExamples.console
  })));
};
exports.IndexSearchExample = IndexSearchExample;