"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexDetailsPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _searchApiKeysComponents = require("@kbn/search-api-keys-components");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _use_navigate_to_discover = require("../../hooks/use_navigate_to_discover");
var _use_index = require("../../hooks/api/use_index");
var _use_kibana = require("../../hooks/use_kibana");
var _connection_details = require("../connection_details/connection_details");
var _quick_stats = require("../quick_stats/quick_stats");
var _use_index_mappings = require("../../hooks/api/use_index_mappings");
var _details_page_data = require("./details_page_data");
var _delete_index_modal = require("./delete_index_modal");
var _details_page_loading_error = require("./details_page_loading_error");
var _routes = require("../../routes");
var _details_page_mappings = require("./details_page_mappings");
var _details_page_settings = require("./details_page_settings");
var _details_page_menu_item = require("./details_page_menu_item");
var _use_document_search = require("../../hooks/api/use_document_search");
var _usage_tracker_context = require("../../contexts/usage_tracker_context");
var _constants = require("../../analytics/constants");
var _use_user_permissions = require("../../hooks/api/use_user_permissions");
var _use_page_chrome = require("../../hooks/use_page_chrome");
var _use_index_management_breadcrumbs = require("../../hooks/use_index_management_breadcrumbs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchIndexDetailsPage = () => {
  var _indexDocuments$resul, _cloud$isServerlessEn;
  const indexName = decodeURIComponent((0, _reactRouterDom.useParams)().indexName);
  const tabId = decodeURIComponent((0, _reactRouterDom.useParams)().tabId);
  const {
    cloud,
    console: consolePlugin,
    docLinks,
    application,
    history,
    share,
    searchNavigation,
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const {
    data: index,
    refetch,
    isError: isIndexError,
    isInitialLoading,
    error: indexLoadingError
  } = (0, _use_index.useIndex)(indexName);
  const {
    data: mappings,
    isError: isMappingsError,
    isInitialLoading: isMappingsInitialLoading,
    error: mappingsError
  } = (0, _use_index_mappings.useIndexMapping)(indexName);
  const {
    data: indexDocuments,
    isInitialLoading: indexDocumentsIsInitialLoading
  } = (0, _use_document_search.useIndexDocumentSearch)(indexName);
  const {
    data: userPrivileges
  } = (0, _use_user_permissions.useUserPrivilegesQuery)(indexName);
  const navigateToPlayground = (0, _react.useCallback)(async () => {
    const playgroundLocator = share.url.locators.get('PLAYGROUND_LOCATOR_ID');
    const isSearchAvailable = uiSettings.get('searchPlayground:searchModeEnabled', false);
    if (playgroundLocator && index) {
      await playgroundLocator.navigate({
        'default-index': index.name,
        search: isSearchAvailable
      });
    }
  }, [share, index, uiSettings]);
  const navigateToDiscover = (0, _use_navigate_to_discover.useNavigateToDiscover)(indexName);
  const hasDocuments = Boolean(isInitialLoading || (indexDocuments === null || indexDocuments === void 0 ? void 0 : (_indexDocuments$resul = indexDocuments.results) === null || _indexDocuments$resul === void 0 ? void 0 : _indexDocuments$resul.data.length));
  const indexManagementBreadcrumbs = (0, _use_index_management_breadcrumbs.useIndexManagementBreadcrumbs)();
  (0, _use_page_chrome.usePageChrome)(indexName, [...indexManagementBreadcrumbs, {
    text: indexName
  }]);
  const usageTracker = (0, _usage_tracker_context.useUsageTracker)();
  const detailsPageTabs = (0, _react.useMemo)(() => {
    return [{
      id: _routes.SearchIndexDetailsTabs.DATA,
      name: _i18n.i18n.translate('xpack.searchIndices.documentsTabLabel', {
        defaultMessage: 'Data'
      }),
      content: /*#__PURE__*/_react.default.createElement(_details_page_data.IndexDetailsData, {
        indexName: indexName,
        indexDocuments: indexDocuments,
        isInitialLoading: indexDocumentsIsInitialLoading,
        userPrivileges: userPrivileges,
        navigateToPlayground: navigateToPlayground
      }),
      'data-test-subj': `${_routes.SearchIndexDetailsTabs.DATA}Tab`
    }, {
      id: _routes.SearchIndexDetailsTabs.MAPPINGS,
      name: _i18n.i18n.translate('xpack.searchIndices.mappingsTabLabel', {
        defaultMessage: 'Mappings'
      }),
      content: /*#__PURE__*/_react.default.createElement(_details_page_mappings.SearchIndexDetailsMappings, {
        index: index,
        userPrivileges: userPrivileges
      }),
      'data-test-subj': `${_routes.SearchIndexDetailsTabs.MAPPINGS}Tab`
    }, {
      id: _routes.SearchIndexDetailsTabs.SETTINGS,
      name: _i18n.i18n.translate('xpack.searchIndices.settingsTabLabel', {
        defaultMessage: 'Settings'
      }),
      content: /*#__PURE__*/_react.default.createElement(_details_page_settings.SearchIndexDetailsSettings, {
        indexName: indexName,
        userPrivileges: userPrivileges
      }),
      'data-test-subj': `${_routes.SearchIndexDetailsTabs.SETTINGS}Tab`
    }];
  }, [index, indexName, indexDocuments, indexDocumentsIsInitialLoading, userPrivileges, navigateToPlayground]);
  const [selectedTab, setSelectedTab] = (0, _react.useState)(detailsPageTabs[0]);
  (0, _react.useEffect)(() => {
    const newTab = detailsPageTabs.find(tab => tab.id === tabId);
    if (newTab) setSelectedTab(newTab);
  }, [detailsPageTabs, tabId]);
  const handleTabClick = (0, _react.useCallback)(tab => {
    history.push(`index_details/${indexName}/${tab.id}`);
    const tabEvent = {
      [_routes.SearchIndexDetailsTabs.DATA]: _constants.AnalyticsEvents.indexDetailsNavDataTab,
      [_routes.SearchIndexDetailsTabs.MAPPINGS]: _constants.AnalyticsEvents.indexDetailsNavMappingsTab,
      [_routes.SearchIndexDetailsTabs.SETTINGS]: _constants.AnalyticsEvents.indexDetailsNavSettingsTab
    }[tab.id];
    if (tabEvent) {
      usageTracker.click(tabEvent);
    }
  }, [history, indexName, usageTracker]);
  const embeddableConsole = (0, _react.useMemo)(() => consolePlugin !== null && consolePlugin !== void 0 && consolePlugin.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(consolePlugin.EmbeddableConsole, null) : null, [consolePlugin]);
  const navigateToIndexListPage = (0, _react.useCallback)(() => {
    application.navigateToApp('management', {
      deepLinkId: 'index_management'
    });
  }, [application]);
  const refetchIndex = (0, _react.useCallback)(() => {
    refetch();
  }, [refetch]);
  const indexError = (0, _react.useMemo)(() => {
    var _indexLoadingError$bo, _indexLoadingError$bo2, _mappingsError$body, _mappingsError$body2;
    return isIndexError ? {
      title: indexLoadingError ? (_indexLoadingError$bo = indexLoadingError.body) === null || _indexLoadingError$bo === void 0 ? void 0 : _indexLoadingError$bo.error : '',
      message: indexLoadingError ? (_indexLoadingError$bo2 = indexLoadingError.body) === null || _indexLoadingError$bo2 === void 0 ? void 0 : _indexLoadingError$bo2.message : ''
    } : {
      title: mappingsError ? (_mappingsError$body = mappingsError.body) === null || _mappingsError$body === void 0 ? void 0 : _mappingsError$body.error : '',
      message: mappingsError ? (_mappingsError$body2 = mappingsError.body) === null || _mappingsError$body2 === void 0 ? void 0 : _mappingsError$body2.message : ''
    };
  }, [isIndexError, indexLoadingError, mappingsError]);
  const [isShowingDeleteModal, setShowDeleteIndexModal] = (0, _react.useState)(false);
  const handleDeleteIndexModal = (0, _react.useCallback)(() => {
    setShowDeleteIndexModal(!isShowingDeleteModal);
  }, [isShowingDeleteModal]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (isInitialLoading || isMappingsInitialLoading || indexDocumentsIsInitialLoading) {
    return /*#__PURE__*/_react.default.createElement(_public.SectionLoading, null, _i18n.i18n.translate('xpack.searchIndices.loadingDescription', {
      defaultMessage: 'Loading index details…'
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    offset: 0,
    restrictWidth: false,
    "data-test-subj": "searchIndicesDetailsPage",
    grow: false,
    panelled: true,
    bottomBorder: true,
    solutionNav: searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.useClassicNavigation(history)
  }, isIndexError || isMappingsError || !index || !mappings || !indexDocuments ? /*#__PURE__*/_react.default.createElement(_details_page_loading_error.IndexloadingError, {
    error: indexError,
    navigateToIndexListPage: navigateToIndexListPage,
    reloadFunction: refetchIndex
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, {
    restrictWidth: true,
    "data-test-subj": "searchIndexDetailsHeader",
    pageTitle: index === null || index === void 0 ? void 0 : index.name,
    bottomBorder: false,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m"
    }, hasDocuments ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      isLoading: isInitialLoading,
      "data-test-subj": "viewInDiscoverLink",
      onClick: navigateToDiscover
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchIndices.indexAction.useInPlaygroundButtonLabel",
      defaultMessage: "View in Discover"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isLoading: isInitialLoading,
      "data-test-subj": "useInPlaygroundLink",
      onClick: navigateToPlayground,
      iconType: "launch",
      fill: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchIndices.indexAction.useInPlaygroundButtonLabel",
      defaultMessage: "Search in Playground"
    })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      href: docLinks.links.apiReference,
      target: "_blank",
      isLoading: isInitialLoading,
      iconType: "documentation",
      "data-test-subj": "ApiReferenceDoc"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchIndices.indexAction.ApiReferenceButtonLabel",
      defaultMessage: "API Reference"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_details_page_menu_item.SearchIndexDetailsPageMenuItemPopover, {
      handleDeleteIndexModal: handleDeleteIndexModal,
      showApiReference: hasDocuments,
      userPrivileges: userPrivileges
    })))]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    grow: false,
    restrictWidth: true,
    css: {
      padding: `0 ${euiTheme.size.l} ${euiTheme.size.l}`
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: {
      overflow: 'auto'
    },
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 400
    }
  }, /*#__PURE__*/_react.default.createElement(_connection_details.ConnectionDetails, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 400
    }
  }, /*#__PURE__*/_react.default.createElement(_searchApiKeysComponents.ApiKeyForm, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_quick_stats.QuickStats, {
    isStateless: (_cloud$isServerlessEn = cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled) !== null && _cloud$isServerlessEn !== void 0 ? _cloud$isServerlessEn : false,
    indexDocuments: indexDocuments,
    index: index,
    mappings: mappings
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: detailsPageTabs,
    onTabClick: handleTabClick,
    selectedTab: selectedTab
  })))))), isShowingDeleteModal && /*#__PURE__*/_react.default.createElement(_delete_index_modal.DeleteIndexModal, {
    onCancel: () => setShowDeleteIndexModal(!isShowingDeleteModal),
    indexName: indexName,
    navigateToIndexListPage: navigateToIndexListPage
  }), embeddableConsole);
};
exports.SearchIndexDetailsPage = SearchIndexDetailsPage;