"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectToElasticsearchSidePanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectToElasticsearchSidePanel = () => {
  const {
    application
  } = (0, _use_kibana.useKibana)().services;
  const onFileUpload = (0, _react.useCallback)(() => {
    application.navigateToApp('ml', {
      path: 'filedatavisualizer'
    });
  }, [application]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    display: "plain",
    hasBorder: true,
    textAlign: "left",
    titleSize: "xs",
    title: _i18n.i18n.translate('xpack.searchHomepage.connectToElasticsearch.uploadFileTitle', {
      defaultMessage: 'Upload a file'
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchHomepage.connectToElasticsearch.uploadFileDescription",
      defaultMessage: "Analyze and import data from a file."
    }),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: onFileUpload,
      iconType: "importAction",
      "data-test-subj": "uploadFileButton"
    }, _i18n.i18n.translate('xpack.searchHomepage.connectToElasticsearch.uploadFileButton', {
      defaultMessage: 'Upload a file'
    }))
  })));
};
exports.ConnectToElasticsearchSidePanel = ConnectToElasticsearchSidePanel;