"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AISearchWorkflow = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_kibana = require("../../hooks/use_kibana");
var _workflow_feature_bullet = require("./workflow_feature_bullet");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AISearchWorkflow = ({
  capability
}) => {
  var _share$url$locators$g;
  const currentBreakpoint = (0, _eui.useCurrentEuiBreakpoint)();
  const {
    share
  } = (0, _use_kibana.useKibana)().services;
  const createIndexUrl = share === null || share === void 0 ? void 0 : (_share$url$locators$g = share.url.locators.get('SEARCH_CREATE_INDEX')) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.useUrl({});
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    direction: currentBreakpoint === 'xl' ? 'row' : 'column'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    src: capability.image,
    alt: capability.imageAlt,
    size: "s"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, capability.heading)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, capability.subheading)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, capability.featureBullets.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: index
  }, /*#__PURE__*/_react.default.createElement(_workflow_feature_bullet.WorkflowFeatureBullet, {
    feature: item
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    href: createIndexUrl,
    "data-test-subj": capability.dataTestSubj
  }, capability.buttonLabel)))));
};
exports.AISearchWorkflow = AISearchWorkflow;