"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionToMenuItem = (action, onActionSelected, closePopover) => {
  return {
    name: action.label,
    icon: action.icon,
    onClick: () => {
      closePopover();
      onActionSelected(action);
    },
    'data-test-subj': `actionBar-button-${action.id}`
  };
};
const ActionBar = ({
  actions,
  onActionSelected,
  selectedCount,
  totalCount
}) => {
  const [isPopoverOpened, setPopOverOpened] = (0, _react.useState)(false);
  const closePopover = (0, _react.useCallback)(() => {
    setPopOverOpened(false);
  }, [setPopOverOpened]);
  const togglePopover = (0, _react.useCallback)(() => {
    setPopOverOpened(opened => !opened);
  }, [setPopOverOpened]);
  const contextMenuPanels = (0, _react.useMemo)(() => {
    return [{
      id: 0,
      items: actions.map(action => actionToMenuItem(action, onActionSelected, closePopover))
    }];
  }, [actions, onActionSelected, closePopover]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.savedObjectsTagging.management.actionBar.totalTagsLabel",
    defaultMessage: "{count, plural, one {1 tag} other {# tags}}",
    values: {
      count: totalCount
    }
  }))), selectedCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "tagMgt__actionBarDivider"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpened,
    closePopover: closePopover,
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: togglePopover,
      "data-test-subj": "actionBar-contextMenuButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.savedObjectsTagging.management.actionBar.selectedTagsLabel",
      defaultMessage: "{count, plural, one {1 selected tag} other {# selected tags}}",
      values: {
        count: selectedCount
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      className: "tagMgt__actionBarIcon",
      type: "arrowDown",
      size: "s"
    })))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: contextMenuPanels,
    "data-test-subj": "actionBar-contextMenu"
  }))))));
};
exports.ActionBar = ActionBar;
const styles = ({
  euiTheme
}) => (0, _react2.css)({
  borderBottom: euiTheme.border.thin,
  paddingBotton: euiTheme.size.s,
  '.tagMgt__actionBarIcon': {
    marginLeft: euiTheme.size.xs
  },
  '.tagMgt__actionBarDivider': {
    height: euiTheme.size.base,
    borderRight: euiTheme.border.thin
  }
});