"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createJob = createJob;
exports.deleteJobs = deleteJobs;
exports.loadJobs = loadJobs;
exports.startJobs = startJobs;
exports.stopJobs = stopJobs;
exports.validateIndexPattern = validateIndexPattern;
var _common = require("../../../common");
var _http_provider = require("./http_provider");
var _track_ui_metric = require("./track_ui_metric");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const apiPrefix = '/api/rollup';
async function loadJobs({
  asSystemRequest
} = {}) {
  const fetchOptions = {
    asSystemRequest
  };
  const {
    jobs
  } = await (0, _http_provider.getHttp)().get(`${apiPrefix}/jobs`, fetchOptions);
  return jobs;
}
async function startJobs(jobIds) {
  const body = {
    jobIds
  };
  const request = (0, _http_provider.getHttp)().post(`${apiPrefix}/start`, {
    body: JSON.stringify(body)
  });
  const actionType = jobIds.length > 1 ? _common.UIM_JOB_START_MANY : _common.UIM_JOB_START;
  return await (0, _track_ui_metric.trackUserRequest)(request, actionType);
}
async function stopJobs(jobIds) {
  const body = {
    jobIds
  };
  const request = (0, _http_provider.getHttp)().post(`${apiPrefix}/stop`, {
    body: JSON.stringify(body)
  });
  const actionType = jobIds.length > 1 ? _common.UIM_JOB_STOP_MANY : _common.UIM_JOB_STOP;
  return await (0, _track_ui_metric.trackUserRequest)(request, actionType);
}
async function deleteJobs(jobIds) {
  const body = {
    jobIds
  };
  const request = (0, _http_provider.getHttp)().post(`${apiPrefix}/delete`, {
    body: JSON.stringify(body)
  });
  const actionType = jobIds.length > 1 ? _common.UIM_JOB_DELETE_MANY : _common.UIM_JOB_DELETE;
  return await (0, _track_ui_metric.trackUserRequest)(request, actionType);
}
async function createJob(job) {
  const body = {
    job
  };
  const request = (0, _http_provider.getHttp)().put(`${apiPrefix}/create`, {
    body: JSON.stringify(body)
  });
  return await (0, _track_ui_metric.trackUserRequest)(request, _common.UIM_JOB_CREATE);
}
async function validateIndexPattern(indexPattern) {
  return await (0, _http_provider.getHttp)().get(`${apiPrefix}/index_pattern_validity/${indexPattern}`);
}